% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyplot_land.R
\name{shinyplot.sf}
\alias{shinyplot.sf}
\title{Shiny app with interactive plots and maps}
\usage{
\method{shinyplot}{sf}(x, SpParams = NULL, r = NULL, ...)
}
\arguments{
\item{x}{The object of class 'sf' containing information to be drawn (see details).}

\item{SpParams}{A data frame with species parameters (see \code{\link[medfate]{SpParamsMED}}), required for most forest stand variables.}

\item{r}{An object of class \code{\link[terra]{SpatRaster}}, defining the raster topology.}

\item{...}{Additional parameters for function shinyplot (not used).}
}
\value{
An object that represents the shiny app
}
\description{
Creates a shiny app with interactive plots for spatial inputs and simulation results
}
\details{
Only run this function in interactive mode. The shiny app can be used to display spatial inputs or simulation results.

\emph{Spatial inputs}:
This is the case if the user supplies an object of class \code{\link[sf]{sf}} with simulation inputs.

\emph{Simulation result summaries}:
This is the case if the user supplies an object of class \code{\link[sf]{sf}} with simulation summaries. Available plots depend on the summary function used to create the result summaries.
}
\seealso{
\code{\link{plot_summary}}, \code{\link{extract_variables}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
