% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R
\name{hash.functionCall}
\alias{hash.functionCall}
\title{Hash}
\usage{
\method{hash}{functionCall}(value)
}
\arguments{
\item{value}{value to hash}
}
\value{
hashed value as a string
}
\description{
Hashes a function call, taking into account the values provided to the function call and unprovided
default values.  Ensures the order the parameters are provided does not change the outcome of the
hash calculation.
}
\examples{
my.function <- function (x, y) x+y

# a list of values to hash
values <- list(
  "Hello world!",
  101,
  3.142,
  TRUE,
  my.function,
  (function (x, y) x+y),
  functionCall(my.function, call("my.function", 10, 10)),
  list(a=1, b=2, c="hello")
)

# hash the values in the list
(hashes <- lapply(values, hash))

# Note that functions with the same body will have the same hash
hashes[[5]] == hashes[[6]]
}
