% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metagen.R
\name{metagen}
\alias{metagen}
\title{Generic inverse variance meta-analysis}
\usage{
metagen(
  TE,
  seTE,
  studlab,
  data = NULL,
  subset = NULL,
  exclude = NULL,
  cluster = NULL,
  rho = 0,
  cycles = NULL,
  weights = NULL,
  weights.common = weights,
  weights.random = weights,
  sm = "",
  method.ci = if (missing(df)) "z" else "t",
  level = gs("level"),
  common = gs("common"),
  random = gs("random") | !is.null(tau.preset),
  overall = common | random,
  overall.hetstat = if (is.null(gs("overall.hetstat"))) common | random else
    gs("overall.hetstat"),
  prediction = gs("prediction") | !missing(method.predict),
  method.tau = gs("method.tau"),
  method.tau.ci = gs("method.tau.ci"),
  level.hetstat = gs("level.hetstat"),
  tau.preset = NULL,
  TE.tau = NULL,
  tau.common = gs("tau.common"),
  detail.tau = NULL,
  method.I2 = gs("method.I2"),
  level.ma = gs("level.ma"),
  method.common.ci = gs("method.common.ci"),
  method.random.ci = gs("method.random.ci"),
  adhoc.hakn.ci = gs("adhoc.hakn.ci"),
  level.predict = gs("level.predict"),
  method.predict = gs("method.predict"),
  adhoc.hakn.pi = gs("adhoc.hakn.pi"),
  seed.predict = NULL,
  null.effect = 0,
  method.bias = gs("method.bias"),
  n.e = NULL,
  n.c = NULL,
  pval,
  df,
  lower,
  upper,
  level.ci = 0.95,
  median,
  q1,
  q3,
  min,
  max,
  method.mean = "Luo",
  method.sd = "Shi",
  approx.TE,
  approx.seTE,
  transf = gs("transf") & missing(func.transf),
  backtransf = gs("backtransf") | !missing(func.backtransf),
  func.transf,
  func.backtransf,
  args.transf,
  args.backtransf,
  pscale = 1,
  irscale = 1,
  irunit = "person-years",
  text.common = gs("text.common"),
  text.random = gs("text.random"),
  text.predict = gs("text.predict"),
  text.w.common = gs("text.w.common"),
  text.w.random = gs("text.w.random"),
  title = gs("title"),
  complab = gs("complab"),
  outclab = "",
  label.e = gs("label.e"),
  label.c = gs("label.c"),
  label.left = gs("label.left"),
  label.right = gs("label.right"),
  col.label.left = gs("col.label.left"),
  col.label.right = gs("col.label.right"),
  subgroup,
  subgroup.name = NULL,
  print.subgroup.name = gs("print.subgroup.name"),
  sep.subgroup = gs("sep.subgroup"),
  test.subgroup = gs("test.subgroup"),
  prediction.subgroup = gs("prediction.subgroup"),
  seed.predict.subgroup = NULL,
  byvar,
  id,
  adhoc.hakn,
  keepdata = gs("keepdata"),
  keeprma = gs("keeprma"),
  warn = gs("warn"),
  warn.deprecated = gs("warn.deprecated"),
  control = NULL,
  ...
)
}
\arguments{
\item{TE}{Estimate of treatment effect, e.g., log hazard ratio or
risk difference or an R object created with \code{\link{pairwise}}.}

\item{seTE}{Standard error of treatment estimate or standard deviation of
n-of-1 trials.}

\item{studlab}{An optional vector with study labels.}

\item{data}{An optional data frame containing the study
information.}

\item{subset}{An optional vector specifying a subset of studies to
be used (see Details).}

\item{exclude}{An optional vector specifying studies to exclude
from meta-analysis, however, to include in printouts and forest
plots (see Details).}

\item{cluster}{An optional vector specifying which estimates come
from the same cluster resulting in the use of a three-level
meta-analysis model.}

\item{rho}{Assumed correlation of estimates within a cluster.}

\item{cycles}{A numeric vector with the number of cycles per patient / study
in n-of-1 trials.}

\item{weights}{A single numeric or vector with user-specified weights.}

\item{weights.common}{User-specified weights (common effect model).}

\item{weights.random}{User-specified weights (random effects model).}

\item{sm}{A character string indicating underlying summary measure,
e.g., \code{"RD"}, \code{"RR"}, \code{"OR"}, \code{"ASD"},
\code{"HR"}, \code{"MD"}, \code{"SMD"}, or \code{"ROM"}.}

\item{method.ci}{A character string indicating which method is used
to calculate confidence intervals for individual studies, see
Details.}

\item{level}{The level used to calculate confidence intervals for
individual studies.}

\item{common}{A logical indicating whether a common effect
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{overall}{A logical indicating whether overall summaries
should be reported. This argument is useful in a meta-analysis
with subgroups if overall results should not be reported.}

\item{overall.hetstat}{A logical value indicating whether to print
heterogeneity measures for overall treatment comparisons. This
argument is useful in a meta-analysis with subgroups if
heterogeneity statistics should only be printed on subgroup
level.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau} (see \code{\link{meta-package}}).}

\item{method.tau.ci}{A character string indicating which method is
used to estimate the confidence interval of \eqn{\tau^2} and
\eqn{\tau} (see \code{\link{meta-package}}).}

\item{level.hetstat}{The level used to calculate confidence intervals
for heterogeneity statistics.}

\item{tau.preset}{Prespecified value for the square root of the
between-study variance \eqn{\tau^2}.}

\item{TE.tau}{Overall treatment effect used to estimate the
between-study variance tau-squared.}

\item{tau.common}{A logical indicating whether tau-squared should
be the same across subgroups.}

\item{detail.tau}{Detail on between-study variance estimate.}

\item{method.I2}{A character string indicating which method is
used to estimate the heterogeneity statistic I\eqn{^2}. Either
\code{"Q"} or \code{"tau2"}, can be abbreviated
(see \code{\link{meta-package}}).}

\item{level.ma}{The level used to calculate confidence intervals
for meta-analysis estimates.}

\item{method.common.ci}{A character string indicating which method
is used to calculate confidence interval and test statistic for
common effect estimate (see \code{\link{meta-package}}).}

\item{method.random.ci}{A character string indicating which method
is used to calculate confidence interval and test statistic for
random effects estimate (see \code{\link{meta-package}}).}

\item{adhoc.hakn.ci}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied in the case
of an arbitrarily small Hartung-Knapp variance estimate (see
\code{\link{meta-package}}).}

\item{level.predict}{The level used to calculate prediction
interval for a new study.}

\item{method.predict}{A character string indicating which method is
used to calculate a prediction interval (see
\code{\link{meta-package}}).}

\item{adhoc.hakn.pi}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied for
prediction interval (see \code{\link{meta-package}}).}

\item{seed.predict}{A numeric value used as seed to calculate
bootstrap prediction interval (see \code{\link{meta-package}}).}

\item{null.effect}{A numeric value specifying the effect under the
null hypothesis.}

\item{method.bias}{A character string indicating which test is to
be used. Either \code{"Begg"}, \code{"Egger"}, or
\code{"Thompson"}, can be abbreviated. See function
\code{\link{metabias}}.}

\item{n.e}{Number of observations in experimental group (or total
sample size in study).}

\item{n.c}{Number of observations in control group.}

\item{pval}{P-value (used to estimate the standard error).}

\item{df}{Degrees of freedom (used in test or to construct
confidence intervals).}

\item{lower}{Lower limit of confidence interval (used to estimate
the standard error).}

\item{upper}{Upper limit of confidence interval (used to estimate
the standard error).}

\item{level.ci}{Level of confidence interval.}

\item{median}{Median (used to estimate the treatment effect and
standard error).}

\item{q1}{First quartile (used to estimate the treatment effect and
standard error).}

\item{q3}{Third quartile (used to estimate the treatment effect and
standard error).}

\item{min}{Minimum (used to estimate the treatment effect and
standard error).}

\item{max}{Maximum (used to estimate the treatment effect and
standard error).}

\item{method.mean}{A character string indicating which method to
use to approximate the mean from the median and other statistics
(see Details).}

\item{method.sd}{A character string indicating which method to use
to approximate the standard deviation from sample size, median,
interquartile range and range (see Details).}

\item{approx.TE}{Approximation method to estimate treatment
estimate (see Details).}

\item{approx.seTE}{Approximation method to estimate standard error
(see Details).}

\item{transf}{A logical indicating whether inputs for arguments
\code{TE}, \code{lower} and \code{upper} are already
appropriately transformed to conduct the meta-analysis or on the
original scale. If \code{transf = TRUE} (default), inputs are
expected to be log odds ratios instead of odds ratios for
\code{sm = "OR"} and Fisher's z transformed correlations instead
of correlations for \code{sm = "ZCOR"}, for example.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and plots. If \code{backtransf =
TRUE} (default), results for \code{sm = "OR"} are printed as odds
ratios rather than log odds ratios and results for \code{sm =
"ZCOR"} are printed as correlations rather than Fisher's z
transformed correlations, for example.}

\item{func.transf}{A function used to transform inputs for
arguments \code{TE}, \code{lower} and \code{upper}.}

\item{func.backtransf}{A function used to back-transform results.}

\item{args.transf}{An optional list to provide additional arguments
to \code{func.transf}.}

\item{args.backtransf}{An optional list to provide additional
arguments to \code{func.backtransf}.}

\item{pscale}{A numeric giving scaling factor for printing of
single event probabilities or risk differences, i.e. if argument
\code{sm} is equal to \code{"PLOGIT"}, \code{"PLN"},
\code{"PRAW"}, \code{"PAS"}, \code{"PFT"}, or \code{"RD"}.}

\item{irscale}{A numeric defining a scaling factor for printing of
single incidence rates or incidence rate differences, i.e. if
argument \code{sm} is equal to \code{"IR"}, \code{"IRLN"},
\code{"IRS"}, \code{"IRFT"}, or \code{"IRD"}.}

\item{irunit}{A character specifying the time unit used to
calculate rates, e.g. person-years.}

\item{text.common}{A character string used in printouts and forest
plot to label the pooled common effect estimate.}

\item{text.random}{A character string used in printouts and forest
plot to label the pooled random effects estimate.}

\item{text.predict}{A character string used in printouts and forest
plot to label the prediction interval.}

\item{text.w.common}{A character string used to label weights of
common effect model.}

\item{text.w.random}{A character string used to label weights of
random effects model.}

\item{title}{Title of meta-analysis / systematic review.}

\item{complab}{Comparison label.}

\item{outclab}{Outcome label.}

\item{label.e}{Label for experimental group.}

\item{label.c}{Label for control group.}

\item{label.left}{Graph label on left side of null effect in forest plot.}

\item{label.right}{Graph label on right side of null effect in forest plot.}

\item{col.label.left}{The colour of the graph label on the left side of
the null effect.}

\item{col.label.right}{The colour of the graph label on the right side of
the null effect.}

\item{subgroup}{An optional vector to conduct a meta-analysis with
subgroups.}

\item{subgroup.name}{A character string with a name for the
subgroup variable.}

\item{print.subgroup.name}{A logical indicating whether the name of
the subgroup variable should be printed in front of the group
labels.}

\item{sep.subgroup}{A character string defining the separator
between name of subgroup variable and subgroup label.}

\item{test.subgroup}{A logical value indicating whether to print
results of test for subgroup differences.}

\item{prediction.subgroup}{A logical indicating whether prediction
intervals should be printed for subgroups.}

\item{seed.predict.subgroup}{A numeric vector providing seeds to
calculate bootstrap prediction intervals within subgroups. Must
be of same length as the number of subgroups.}

\item{byvar}{Deprecated argument (replaced by 'subgroup').}

\item{id}{Deprecated argument (replaced by 'cluster').}

\item{adhoc.hakn}{Deprecated argument (replaced by
'adhoc.hakn.ci').}

\item{keepdata}{A logical indicating whether original data (set)
should be kept in meta object.}

\item{keeprma}{A logical indicating whether \code{\link[metafor]{rma.mv}}
object from three-level meta-analysis should be stored.}

\item{warn}{A logical indicating whether warnings should be printed
(e.g., if studies are excluded from meta-analysis due to zero
standard errors).}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{control}{An optional list to control the iterative process to
estimate the between-study variance \eqn{\tau^2}. This argument
is passed on to \code{\link[metafor]{rma.uni}} or
\code{\link[metafor]{rma.mv}}.}

\item{\dots}{Additional arguments (to catch deprecated arguments).}
}
\value{
An object of class \code{c("metagen", "meta")} with corresponding
generic functions (see \code{\link{meta-object}}).
}
\description{
Common effect and random effects meta-analysis based on estimates
(e.g. log hazard ratios) and their standard errors. The inverse
variance method is used for pooling.

Three-level random effects meta-analysis (Van den Noortgate et al., 2013) is
available by internally calling \code{\link[metafor]{rma.mv}} function from
R package \bold{metafor} (Viechtbauer, 2010).
}
\details{
This function provides the \emph{generic inverse variance method}
for meta-analysis which requires treatment estimates and their
standard errors (Borenstein et al., 2010). The method is useful,
e.g., for pooling of survival data (using log hazard ratio and
standard errors as input). Arguments \code{TE} and \code{seTE} can
be used to provide treatment estimates and standard errors
directly. However, it is possible to derive these quantities from
other information.

Argument \code{cycles} can be used to conduct a meta-analysis of n-of-1
trials according to Senn (2024). In this case, argument \code{seTE} does
not contain the standard error but standard deviation for individual
trials / patients. Trial-specific standard errors are calculated from an
average standard deviation multiplied by the number of cycles minus 1, i.e.,
the degrees of freedom. Details of the meta-analysis method are provided in
Senn (2024). Note, arguments used in the approximation of means or
standard errors, like \code{lower} and \code{upper}, or \code{df}, are
ignored for the meta-analysis of n-of-1 trials.

A three-level random effects meta-analysis model (Van den Noortgate
et al., 2013) is utilised if argument \code{cluster} is used and at
least one cluster provides more than one estimate. Internally,
\code{\link[metafor]{rma.mv}} is called to conduct the analysis and
\code{\link[metafor]{weights.rma.mv}} with argument \code{type =
"rowsum"} is used to calculate random effects weights.

Default settings are utilised for several arguments (assignments
using \code{\link{gs}} function). These defaults can be changed for
the current R session using the \code{\link{settings.meta}}
function.

Furthermore, R function \code{\link{update.meta}} can be used to
rerun a meta-analysis with different settings.

\subsection{Approximate treatment estimates}{

Missing treatment estimates can be derived from
\enumerate{
\item confidence limits provided by arguments \code{lower} and
  \code{upper};
\item median, interquartile range and range (arguments
  \code{median}, \code{q1}, \code{q3}, \code{min}, and \code{max});
\item median and interquartile range (arguments \code{median},
  \code{q1} and \code{q3});
\item median and range (arguments \code{median}, \code{min} and
  \code{max}).
}
For confidence limits, the treatment estimate is defined as the
center of the confidence interval (on the log scale for relative
effect measures like the odds ratio or hazard ratio).

If the treatment effect is a mean it can be approximated from
sample size, median, interquartile range and range.

By default, methods described in Luo et al. (2018) are utilised
(argument \code{method.mean = "Luo"}):
\itemize{
\item equation (7) if sample size, median and range are available,
\item equation (11) if sample size, median and interquartile range
  are available,
\item equation (15) if sample size, median, range and interquartile
  range are available.
}

Instead the methods described in Wan et al. (2014) are used if
argument \code{method.mean = "Wan"}:
\itemize{
\item equation (2) if sample size, median and range are available,
\item equation (14) if sample size, median and interquartile range
  are available,
\item equation (10) if sample size, median, range and interquartile
  range are available.
}

The following methods are also available to estimate means from
quantiles or ranges if R package \bold{estmeansd} is installed:
\itemize{
\item Method for Unknown Non-Normal Distributions (MLN) approach
  (Cai et al. (2021), argument \code{method.mean = "Cai"}),
\item Quantile Estimation (QE) method (McGrath et al. (2020),
  argument \code{method.mean = "QE-McGrath"})),
\item Box-Cox (BC) method (McGrath et al. (2020),
  argument \code{method.mean = "BC-McGrath"})).
}

By default, missing treatment estimates are replaced successively
using these method, i.e., confidence limits are utilised before
interquartile ranges. Argument \code{approx.TE} can be used to
overwrite this default for each individual study:
\itemize{
\item Use treatment estimate directly (entry \code{""} in argument
  \code{approx.TE});
\item confidence limits (\code{"ci"} in argument \code{approx.TE});
\item median, interquartile range and range (\code{"iqr.range"});
\item median and interquartile range (\code{"iqr"});
\item median and range (\code{"range"}).
}
}

\subsection{Approximate standard errors}{

Missing standard errors can be derived from
\enumerate{
\item p-value provided by arguments \code{pval} and (optional)
  \code{df};
\item confidence limits (arguments \code{lower}, \code{upper}, and
  (optional) \code{df});
\item sample size, median, interquartile range and range (arguments
  \code{n.e} and / or \code{n.c}, \code{median}, \code{q1},
  \code{q3}, \code{min}, and \code{max});
\item sample size, median and interquartile range (arguments
  \code{n.e} and / or \code{n.c}, \code{median}, \code{q1} and
  \code{q3});
\item sample size, median and range (arguments \code{n.e} and / or
  \code{n.c}, \code{median}, \code{min} and \code{max}).
}
For p-values and confidence limits, calculations are either based
on the standard normal or \emph{t}-distribution if argument
\code{df} is provided. Furthermore, argument \code{level.ci} can be
used to provide the level of the confidence interval.

Wan et al. (2014) describe methods to estimate the standard
deviation (and thus the standard error by deviding the standard
deviation with the square root of the sample size) from the sample
size, median and additional statistics. Shi et al. (2020) provide
an improved estimate of the standard deviation if the interquartile
range and range are available in addition to the sample size and
median. Accordingly, equation (11) in Shi et al. (2020) is the
default (argument \code{method.sd = "Shi"}), if the median,
interquartile range and range are provided (arguments
\code{median}, \code{q1}, \code{q3}, \code{min} and
\code{max}). The method by Wan et al. (2014) is used if argument
\code{method.sd = "Wan"} and, depending on the sample size, either
equation (12) or (13) is used. If only the interquartile range or
range is available, equations (15) / (16) and (7) / (9) in Wan et
al. (2014) are used, respectively. The sample size of individual
studies must be provided with arguments \code{n.e} and / or
\code{n.c}. The total sample size is calculated as \code{n.e} +
\code{n.c} if both arguments are provided.

The following methods are also available to estimate standard
deviations from quantiles or ranges if R package \bold{estmeansd}
is installed:
\itemize{
\item Method for Unknown Non-Normal Distributions (MLN) approach
  (Cai et al. (2021), argument \code{method.mean = "Cai"}),
\item Quantile Estimation (QE) method (McGrath et al. (2020),
  argument \code{method.mean = "QE-McGrath"})),
\item Box-Cox (BC) method (McGrath et al. (2020),
  argument \code{method.mean = "BC-McGrath"})).
}

By default, missing standard errors are replaced successively using
these method, e.g., p-value before confidence limits before
interquartile range and range. Argument \code{approx.seTE} can be
used to overwrite this default for each individual study:

\itemize{
\item Use standard error directly (entry \code{""} in argument
  \code{approx.seTE});
\item p-value (\code{"pval"} in argument \code{approx.seTE});
\item confidence limits (\code{"ci"});
\item median, interquartile range and range (\code{"iqr.range"});
\item median and interquartile range (\code{"iqr"});
\item median and range (\code{"range"}).
}
}

\subsection{Confidence intervals for individual studies}{

For the mean difference (argument \code{sm = "MD"}), the confidence
interval for individual studies can be based on the
\itemize{
\item standard normal distribution (\code{method.ci = "z"}), or
\item \emph{t}-distribution (\code{method.ci = "t"}).
}

By default, the first method is used if argument \code{df} is
missing and the second method otherwise.

Note, this choice does not affect the results of the common effect
and random effects meta-analysis.
}

\subsection{Subgroup analysis}{

Argument \code{subgroup} can be used to conduct subgroup analysis for
a categorical covariate. The \code{\link{metareg}} function can be
used instead for more than one categorical covariate or continuous
covariates.
}

\subsection{Specify the null hypothesis of test for an overall effect}{

Argument \code{null.effect} can be used to specify the (treatment)
effect under the null hypothesis in a test for an overall
effect.

By default (\code{null.effect = 0}), the null hypothesis
corresponds to "no difference" (which is obvious for absolute
effect measures like the mean difference (\code{sm = "MD"}) or
standardised mean difference (\code{sm = "SMD"})). For relative
effect measures, e.g., risk ratio (\code{sm = "RR"}) or odds ratio
(\code{sm = "OR"}), the null effect is defined on the log scale,
i.e., \emph{log}(RR) = 0 or \emph{log}(OR) = 0 which is equivalent
to testing RR = 1 or OR = 1.

Use of argument \code{null.effect} is especially useful for summary
measures without a "natural" null effect, i.e., in situations
without a second (treatment) group. For example, an overall
proportion of 50\% could be tested in the meta-analysis of single
proportions with argument \code{null.effect = 0.5}.

Note, all tests for an overall effect are two-sided with the
alternative hypothesis that the effect is unequal to
\code{null.effect}.
}

\subsection{Exclusion of studies from meta-analysis}{

Arguments \code{subset} and \code{exclude} can be used to exclude
studies from the meta-analysis. Studies are removed completely from
the meta-analysis using argument \code{subset}, while excluded
studies are shown in printouts and forest plots using argument
\code{exclude} (see Examples).
Meta-analysis results are the same for both arguments.
}

\subsection{Presentation of meta-analysis results}{

Internally, both common effect and random effects models are
calculated regardless of values choosen for arguments \code{common}
and \code{random}. Accordingly, the estimate for the random effects
model can be extracted from component \code{TE.random} of an object
of class \code{"meta"} even if argument \code{random =
FALSE}. However, all functions in R package \bold{meta} will
adequately consider the values for \code{common} and
\code{random}. For example, functions \code{\link{print.meta}} and
\code{\link{forest.meta}} will not show results for the random
effects model if \code{random = FALSE}.

A prediction interval will only be shown if \code{prediction =
TRUE}.

Argument \code{pscale} can be used to rescale single proportions or
risk differences, e.g. \code{pscale = 1000} means that proportions
are expressed as events per 1000 observations. This is useful in
situations with (very) low event probabilities.

Argument \code{irscale} can be used to rescale single rates or rate
differences, e.g. \code{irscale = 1000} means that rates are
expressed as events per 1000 time units, e.g. person-years. This is
useful in situations with (very) low rates. Argument \code{irunit}
can be used to specify the time unit used in individual studies
(default: "person-years"). This information is printed in summaries
and forest plots if argument \code{irscale} is not equal to 1.

Default settings for \code{common}, \code{random},
\code{pscale}, \code{irscale}, \code{irunit} and several other
arguments can be set for the whole R session using
\code{\link{settings.meta}}.
}
}
\note{
R function \code{\link[metafor]{rma.uni}} from R package
\pkg{metafor} (Viechtbauer 2010) is called internally to estimate
the between-study variance \eqn{\tau^2}.
}
\examples{
data(Fleiss1993bin)
m1 <- metabin(d.asp, n.asp, d.plac, n.plac, study,
  data = Fleiss1993bin, sm = "RR", method = "I")
m1

# Identical results using the generic inverse variance method with
# log risk ratio and its standard error:
# Note, argument 'n.e' in metagen() is used to provide the total
# sample size which is calculated from the group sample sizes n.e
# and n.c in meta-analysis m1.
m1.gen <- metagen(TE, seTE, studlab, n.e = n.e + n.c, data = m1, sm = "RR")
m1.gen
forest(m1.gen, leftcols = c("studlab", "n.e", "TE", "seTE"))

# Meta-analysis with prespecified between-study variance
#
metagen(m1$TE, m1$seTE, sm = "RR", tau.preset = sqrt(0.1))

# Meta-analysis of survival data:
#
logHR <- log(c(0.95, 1.5))
selogHR <- c(0.25, 0.35)
metagen(logHR, selogHR, sm = "HR")

# Paule-Mandel method to estimate between-study variance for data
# from Paule & Mandel (1982)
#
average <- c(27.044, 26.022, 26.340, 26.787, 26.796)
variance <- c(0.003, 0.076, 0.464, 0.003, 0.014)
#
metagen(average, sqrt(variance), sm = "MD", method.tau = "PM")

# Conduct meta-analysis using hazard ratios and 95\% confidence intervals
#
# Data from Steurer et al. (2006), Analysis 1.1 Overall survival
# https://doi.org/10.1002/14651858.CD004270.pub2
#
study <- c("FCG on CLL 1996", "Leporrier 2001", "Rai 2000", "Robak 2000")
HR <- c(0.55, 0.92, 0.79, 1.18)
lower.HR <- c(0.28, 0.79, 0.59, 0.64)
upper.HR <- c(1.09, 1.08, 1.05, 2.17)
#
# Hazard ratios and confidence intervals as input
#
summary(metagen(HR, lower = lower.HR, upper = upper.HR,
  studlab = study, sm = "HR", transf = FALSE))
#
# Same result with log hazard ratios as input
#
summary(metagen(log(HR), lower = log(lower.HR), upper = log(upper.HR),
  studlab = study, sm = "HR"))
#
# Again, same result using an unknown summary measure and
# arguments 'func.transf' and 'func.backtransf'
#
summary(metagen(HR, lower = lower.HR, upper = upper.HR,
  studlab = study, sm = "Hazard ratio",
  func.transf = log, func.backtransf = exp))
#
# Finally, same result only providing argument 'func.transf' as the
# back-transformation for the logarithm is known
#
summary(metagen(HR, lower = lower.HR, upper = upper.HR,
  studlab = study, sm = "Hazard ratio",
  func.transf = log))

# Exclude MRC-1 and MRC-2 studies from meta-analysis, however,
# show them in printouts and forest plots
#
metabin(d.asp, n.asp, d.plac, n.plac, study,
  data = Fleiss1993bin, sm = "RR", method = "I",
  exclude = study \%in\% c("MRC-1", "MRC-2"))
#
# Exclude MRC-1 and MRC-2 studies completely from meta-analysis
#
metabin(d.asp, n.asp, d.plac, n.plac, study,
  data = Fleiss1993bin, sm = "RR", method = "I",
  subset = !(study \%in\% c("MRC-1", "MRC-2")))

# Exclude studies with total sample size above 1500
#
metabin(d.asp, n.asp, d.plac, n.plac, study,
  data = Fleiss1993bin, sm = "RR", method = "I",
  exclude = (n.asp + n.plac) > 1500)

# Exclude studies containing "MRC" in study name
#
metabin(d.asp, n.asp, d.plac, n.plac, study,
  data = Fleiss1993bin, sm = "RR", method = "I",
  exclude = grep("MRC", study))

# Use both arguments 'subset' and 'exclude'
#
metabin(d.asp, n.asp, d.plac, n.plac, study,
  data = Fleiss1993bin, sm = "RR", method = "I",
  subset = (n.asp + n.plac) > 1500,
  exclude = grep("MRC", study))

\dontrun{
# Three-level model: effects of modified school calendars on
# student achievement
data(dat.konstantopoulos2011, package = "metadat")
metagen(yi, sqrt(vi), studlab = study, data = dat.konstantopoulos2011,
  sm = "SMD",
  cluster = district, detail.tau = c("district", "district/school"))
}

}
\references{
Borenstein M, Hedges LV, Higgins JP, Rothstein HR (2010):
A basic introduction to fixed-effect and random-effects models for
meta-analysis.
\emph{Research Synthesis Methods},
\bold{1}, 97--111

Cai S, Zhou J, Pan J (2021):
Estimating the sample mean and standard deviation from order
statistics and sample size in meta-analysis.
\emph{Statistical Methods in Medical Research},
\bold{30}, 2701--2719

Luo D, Wan X, Liu J, Tong T (2018):
Optimally estimating the sample mean from the sample size, median,
mid-range, and/or mid-quartile range.
\emph{Statistical Methods in Medical Research},
\bold{27}, 1785--805

McGrath S, Zhao X, Steele R, et al. and the DEPRESsion Screening
Data (DEPRESSD) Collaboration (2020):
Estimating the sample mean and standard deviation from commonly
reported quantiles in meta-analysis.
\emph{Statistical Methods in Medical Research},
\bold{29}, 2520--2537

Senn S (2024):
The analysis of continuous data from n-of-1 trials using paired cycles:
a simple tutorial.
\emph{Trials},
\bold{25}.

Shi J, Luo D, Weng H, Zeng X-T, Lin L, Chu H, et al. (2020):
Optimally estimating the sample standard deviation from the
five-number summary.
\emph{Research Synthesis Methods}.

Viechtbauer W (2010):
Conducting Meta-Analyses in R with the metafor Package.
\emph{Journal of Statistical Software},
\bold{36}, 1--48

Van den Noortgate W, López-López JA, Marín-Martínez F, Sánchez-Meca J (2013):
Three-level meta-analysis of dependent effect sizes.
\emph{Behavior Research Methods},
\bold{45}, 576--94

Wan X, Wang W, Liu J, Tong T (2014):
Estimating the sample mean and standard deviation from the sample
size, median, range and/or interquartile range.
\emph{BMC Medical Research Methodology},
\bold{14}, 135
}
\seealso{
\code{\link{meta-package}}, \code{\link{update.meta}},
  \code{\link{metabin}}, \code{\link{metacont}}, \code{\link{pairwise}},
  \code{\link{print.meta}}, \code{\link{settings.meta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
