% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_factor}
\alias{normalize_factor}
\title{Normalize intensities across samples using a normalization factor}
\usage{
normalize_factor(data, factor_column = .data$Factor)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{factor_column}{Which column contains the sample-specific factor? Usually \code{factor_column = Factor}. Uses \code{\link[rlang]{args_data_masking}}.}
}
\value{
A tibble with intensities normalized across samples.
}
\description{
Normalization is done by dividing the intensity by a sample-specific factor (e.g., weight, protein or DNA content).
This function requires a sample-specific factor, usually supplied via the \code{Factor} column from the sample metadata.
See the Examples section for details.
}
\examples{
toy_metaboscape \%>\%
  join_metadata(toy_metaboscape_metadata) \%>\%
  normalize_factor()
}
