% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_load_protspeps.R
\name{load_protspeps}
\alias{load_protspeps}
\title{load_protspeps}
\usage{
load_protspeps(protein_file, peptide_file, metadata_file)
}
\arguments{
\item{protein_file}{Character indicating the location of a txt 
file containing the list of proteins generated in 
\href{http://pappso.inrae.fr/bioinfo/xtandempipeline/}{X!TandemPipeline} 
using an adapted iterative approach described by 
\href{https://www.theses.fr/2019SORUS043}{Bassignani, 2019}. 
Separation between columns should be indicated by tabulation. 
For more details regarding data input check 
\href{https://forgemia.inra.fr/pappso/metaprotr#data-inputs}{format examples}.}

\item{peptide_file}{Character indicating the location of a txt 
file containing peptides abundances expressed as spectral counts.
This file is generated from 
\href{http://pappso.inrae.fr/bioinfo/xtandempipeline/}{X!TandemPipeline} 
using an adapted iterative approach described by 
\href{https://www.theses.fr/2019SORUS043}{Bassignani, 2019}. 
Separation between columns should be indicated by tabulation. 
For more details regarding data input check 
\href{https://forgemia.inra.fr/pappso/metaprotr#data-inputs}{format examples}.}

\item{metadata_file}{Character indicating the location of a csv file 
containing the samples information. The following columns names 
MUST be present: "SC_name" (sample ids assigned by the user), "msrunfile" 
(name of samples as indicated in mass spectrometry files and in the columns
of peptide_file) and "SampleID" (codes indicating the experimental group).
Additional columns containing complementary information can be added by 
the user (ex. replicates, order of injection, etc.). 
Separation between columns should be indicated by tabulation. 
For more details regarding data input check 
\href{https://forgemia.inra.fr/pappso/metaprotr#data-inputs}{format examples}.}
}
\value{
A "metaproteome_object", which is a list of six elements containing: 
   1) dataframe of the protein identifiers, 
   2) dataframe of the peptide identifiers, 
   3) dataframe containing the information of peptides with their associated proteins, 
   4) dataframe of metadata containing the experiment information, 
   5) dataframe of spectral counts per peptide on each sample, 
   6) character indicating the type of object generated.
}
\description{
Loads three files: i) peptides abundances expressed as 
spectral counts, ii) proteins information, and iii) metadata of the
mass spectrometry samples. Combines the three files into a 
"metaproteome_object", a list containing these dataframes.
}
\examples{
\dontrun{

protein_file <- "location/peptides_abundances.csv"
peptide_file <- "location/proteins_list.csv"
metadata <- "location/metadata.csv"
metaproteome <- load_protspeps(protein_file, peptide_file, metadata_file)

}
}
