% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water_quality_analysis.R
\name{water_quality_analysis}
\alias{water_quality_analysis}
\title{Water quality analysis}
\usage{
water_quality_analysis(dataset, store = FALSE, dec_c = ".", verbose = FALSE)
}
\arguments{
\item{dataset}{A data.frame obtained from \code{read_data}.}

\item{store}{A logical value indicating if the user want to store the results in a file.}

\item{dec_c}{A character used for decimal separator on results file.}

\item{verbose}{A logical value indicating if progress messages should be given.}
}
\value{
This function returns a list with the following components:
\item{bioind_n}{The numerical values of the biotic indexes.}
\item{bioind_c}{The water quality class asign to each sample site according to the numerical value of the biotic index.}
\item{densimetrics}{A data.frame with all the calculated density measures.}
\item{tolmetrics}{A data.frame with all the calculated tolerance measures.}
\item{compmetrics}{A data.frame with all the calculated composition measures.}
\item{trophmetrics}{A data.frame with all the calculated trophic measures.}
\item{richmetrics}{A data.frame with all the calculated richness measures.}
}
\description{
This function performs all the calculations available in metrix package.
}
\examples{
#Load example data
example_data

#Run water_quality_analysis with that example_data
complete<-water_quality_analysis(example_data)

#Check results
complete$bioind_n
complete$bioind_c
complete$densimetrics
complete$tolmetrics
complete$compmetrics
complete$trophmetrics
complete$richmetrics
}
\seealso{
\link[metrix]{read_data}, \link[metrix]{biotic_ind}, \link[metrix]{densi_metrics}, \link[metrix]{icbrio_ind}, \link[metrix]{tol_metrics}, \link[metrix]{comp_metrics}, \link[metrix]{troph_metrics}, \link[metrix]{rich_metrics}
}
\author{
Juan Manuel Cabrera and Julieta Capeletti.
}
