% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extgp.R
\name{egp.pll}
\alias{egp.pll}
\title{Profile log likelihood for extended generalized Pareto models}
\usage{
egp.pll(
  psi,
  model = c("pt-beta", "pt-gamma", "pt-power", "gj-tnorm", "gj-beta", "exptilt",
    "logist"),
  param = c("kappa", "scale", "shape", "retlev"),
  mle = NULL,
  xdat,
  thresh = NULL,
  plot = FALSE,
  method = c("Nelder", "nlminb", "BFGS"),
  p,
  ...
)
}
\arguments{
\item{psi}{grid of values for the parameter to profile}

\item{model}{string; choice of extended eneralized Pareto model.}

\item{param}{string; parameter to profile}

\item{mle}{a vector or matrix with maximum likelihood estimates of \code{kappa}, \code{scale}, \code{shape}. This can be a matrix if there are multiple threshold}

\item{xdat}{vector of observations}

\item{thresh}{vector of positive thresholds. If \code{NULL}, defaults to zero.}

\item{plot}{logical; if \code{TRUE}, returns a plot of the profile log likelihood}

\item{method}{string giving the optimization method for the outer optimization in the augmented Lagrangian routine; one of \code{nlminb} or \code{BFGS}}

\item{p}{tail probability for return level if \code{param="retlev"}.}

\item{...}{additional arguments, currently ignored}
}
\value{
an object of class \code{eprof}
}
\description{
Computes the profile log likelihood over a grid of values of \eqn{\psi} for various parameters, including return levels.
}
