% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfp_step.R
\name{find_best_fpm_step}
\alias{find_best_fpm_step}
\title{Function to find the best FP functions of given degree for a single variable}
\usage{
find_best_fpm_step(x, xi, degree, y, powers_current, powers, acdx, family, ...)
}
\arguments{
\item{x}{an input matrix of dimensions nobs x nvars. Does not contain
intercept, but columns are already expanded into dummy variables as
necessary. Data are assumed to be shifted and scaled.}

\item{xi}{a character string indicating the name of the current variable
of interest, for which the best fractional polynomial transformation is
to be estimated in the current step.}

\item{degree}{degrees of freedom for fp transformation of \code{xi}.}

\item{y}{a vector for the response variable or a \code{Surv} object.}

\item{powers_current}{a list of length equal to the number of variables,
indicating the fp powers to be used in the current step for all variables
(except \code{xi}).}

\item{powers}{a named list of numeric values that sets the permitted FP
powers for each covariate.}

\item{acdx}{a logical vector of length nvars indicating continuous variables
to undergo the approximate cumulative distribution (ACD) transformation.}

\item{family}{a character string representing a family object.}

\item{...}{passed to \code{fit_model()}.}
}
\value{
A list with several components:
\itemize{
\item \code{acd}: logical indicating if an ACD transformation was applied for \code{xi}.
\item \code{powers}: fp powers investigated in step.
\item \code{power_best}: the best power found. \code{power_best} will always be a
two-column matrix when an ACD transformation is used, otherwise the number
of columns will depend on \code{degree}.
\item \code{metrics}: a matrix with performance indices for all models investigated.
Same number of rows as, and indexed by, \code{powers}.
\item \code{model_best}: row index of best model in \code{metrics}.
}
}
\description{
Handles the FP1 and the higher order FP cases. For parameter definitions, see
\code{\link[=find_best_fp_step]{find_best_fp_step()}}.
}
\details{
The "best" model is determined by the highest likelihood (or smallest
deviance by our definition as minus twice the log-likelihood). This is also
the case for the use of information criteria, as all models investigated in
this function have the same df, so the penalization term is equal for all
models and only their likelihoods differ.

Note that the estimation of each fp power adds a degree of freedom. Thus,
all fp1s have 2 df, all fp2s have 4 df and so on.

In the case that \code{degree = 1}, the linear model (fp power of 1) is NOT
returned, as it is not considered to be a fractional polynomial in this
algorithm.
A linear model has only one df, whereas the same function regarded as fp
would have 2 fp.
}
\section{ACD transformation}{

This function also handles the case of ACD transformations if \code{acdx} is set
to \code{TRUE} for \code{xi}. In this case, if \code{degree = 1}, then 7 models are
assessed (like for the non-acd case it excludes the linear case),
and if \code{degree = 2}, then 64 models are assessed (unlike the 36 models
for non-acd transformation). Other settings for \code{degree} are currently not
supported when used with ACD transformations.
}

