% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gbsg}
\alias{gbsg}
\title{Breast cancer dataset used in the Royston and Sauerbrei (2008) book.}
\format{
A dataset with 686 observations and 11 variables.
\describe{
\item{id}{Patient identifier.}
\item{age}{Age in years.}
\item{meno}{Menopausal status (0 = premeno, 1 = postmeno).}
\item{size}{Tumor size (mm).}
\item{grade}{Tumor grade.}
\item{nodes}{Number of positive lymph nodes.}
\item{enodes}{exp(-0.12*nodes).}
\item{pgr}{Progesterone receptor status.}
\item{er}{Estrogen receptor status.}
\item{hormon}{Tamoxifen treatment.}
\item{rectime}{Time (days) to death or cancer recurrence.}
\item{censrec}{Censoring (0 = censored, 1 = event).}
}
}
\usage{
data(gbsg)
}
\description{
Breast cancer dataset used in the Royston and Sauerbrei (2008) book.
}
\keyword{data}
