% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulationfunctions.R
\name{datgen}
\alias{datgen}
\title{datgen}
\usage{
datgen(n, m, m0, sigeff, Sigma)
}
\arguments{
\item{n}{number of samples}

\item{m}{number of cords}

\item{m0}{number of non sparse elements}

\item{sigeff}{magnitude of signal}

\item{Sigma}{Covariance matrix}
}
\value{
X data matrix of size nxm
}
\description{
Function to generate data from multivariate normal with different mean.
}
\details{
This function generates data from multivariate normal distribution with given covariance matrix. The mean values are either zero or constant sigeff, randomly permuted among the coordinates.
}
\examples{
\dontrun{
n = 50;m = 250;m0 = 20;
sigeff = 1;
Sigma <- 0.25*diag(m)
X <- datgen(n,m,m0,sigeff,Sigma = Sigma)
}
}

