% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootfunctions.R
\name{pboot.1sample}
\alias{pboot.1sample}
\title{Generate Bootstrap Distribution of p values for one sample tests.}
\usage{
pboot.1sample(X, B = 100, test = t.test, nbx = NROW(X), ncpus = 8)
}
\arguments{
\item{X}{matrix of data, each row is an independent observation nxm}

\item{B}{bootstrap sample size}

\item{test}{function for testing. default is t.test(). Must return a data frame with p value in $p.value.}

\item{nbx}{Sample size for the bootstrap samples. Default is NROW(X), which is same as the original data sample size.}

\item{ncpus}{Number of cpus to use for bootstrap. We use parallel:multicore() to parallelize the bootstrap. For windows, use ncpus = 1, for any other machine, you can use the maximum permissible number for your system.}
}
\value{
matrix of dimension Bxm. (Where m coordinates), each row indicates transformed p values for that bootstrap sample.
}
\description{
Performs bootstrap to generate empirical distribution of order statistics of p values
}
\details{
We generate the bootstrap distribution of the order statistics of the p values. We are performing one sample test on each coordinate of the original dataset. The bootstrap used here is standard version with default bootstrap sample size being equal to data sample size. The default one sample test is t.test(), however the user can provide their own test functions. The only requirement is that it must return p values in $p.value column of the output.
The bootstrap is parallelized using multicore from the library parallel. Windows machines at this point does not support using multiple cores, so the ncpus option should be equal to 1 for windows. For other systems, it can be higher to speed up the process.
We also use a transofrmation of the p values, by default the transformation is -log(1-p). But the user can provide their own transformation function. They should be monotonically increasing functions.
}
\examples{
\dontrun{
n = 50;m = 250;m0 = 20;
sigeff = 1;
Sigma <- 0.25*diag(m)
X <- datgen(n,m,m0,sigeff,Sigma = Sigma)
porder <- pboot.1sample(X=X,B=100,ncpus = 1)
plotpboot(porder)
}
}

