% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_odds_ratio.R
\name{pool_odds_ratio}
\alias{pool_odds_ratio}
\title{Calculates the pooled odds ratio (OR) and related confidence interval.}
\usage{
pool_odds_ratio(object, conf.level = 0.95, dfcom = NULL)
}
\arguments{
\item{object}{An object of class 'mistats' ('Multiply Imputed
Statistical Analysis')}

\item{conf.level}{Confidence level of the confidence intervals.}

\item{dfcom}{Complete data degrees of freedom. Default
number is taken from function \code{odds_ratio}}
}
\value{
The pooled OR and confidence intervals.
}
\description{
\code{pool_odds_ratio} Calculates the pooled odds ratio and
confidence interval.
}
\examples{

library(magrittr)
lbpmilr \%>\%
   df2milist(impvar="Impnr") \%>\%
     with(expr=odds_ratio(Chronic ~ Radiation)) \%>\%
       pool_odds_ratio()

# Same as
imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=odds_ratio(Chronic ~ Radiation))
res <- pool_odds_ratio(ra)

}
\seealso{
\code{\link{with.milist}}, \code{\link{odds_ratio}}
}
\author{
Martijn Heymans, 2021
}
