% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotbeta}
\alias{plotbeta}
\title{plot beta diversity}
\usage{
plotbeta(
  physeq,
  group,
  shape = NULL,
  distance = "bray",
  method = "PCoA",
  color = NULL,
  size = 3,
  ellipse = FALSE
)
}
\arguments{
\item{physeq}{A \code{phyloseq} object containing merged information of abundance,
taxonomic assignment, sample data including the measured variables and categorical information
of the samples, and / or phylogenetic tree if available.}

\item{group}{(Required). Character string specifying name of a categorical variable that is preferred for grouping the information.
information.}

\item{shape}{shape(Optional) Character string specifying shape of a categorical variable}

\item{distance}{A string character specifying dissimilarity index to be used in calculating pairwise distances (Default index is "bray".).
"unifrac","wunifrac","manhattan", "euclidean", "canberra", "bray", "kulczynski", "jaccard", "gower", "altGower",
"morisita", "horn", "mountford", "raup" , "binomial", "chao", "cao" or "mahalanobis".}

\item{method}{A character string specifying ordination method. All methods available to the \code{ordinate} function
of \code{phyloseq} are acceptable here as well.}

\item{color}{user defined color for group}

\item{size}{the point size}

\item{ellipse}{draw ellipse or not}
}
\value{
ggplot2 object
}
\description{
plot beta diversity
}
\examples{
{
data("Physeq")
phy<-normalize(physeq)
plotbeta(phy,group="SampleType")
}
}
\author{
Kai Guo
}
