% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_plates.R
\name{tidy_plates}
\alias{tidy_plates}
\title{Add metadata to values from photometer measurements}
\usage{
tidy_plates(
  input_data,
  how_many = c("single", "multiple"),
  user_prompt = FALSE,
  multiple_structures = FALSE,
  direction = c("horizontal", "vertical"),
  ...
)
}
\arguments{
\item{input_data}{Either a folder path containing text files or a list of data frames.}

\item{how_many}{A character vector specifying if metadata should be added to only a single plate or multiple plates.}

\item{user_prompt}{Logical indicating whether adding metadata should be applied via user prompts. Only applied
if \code{user_prompt} is set to \code{TRUE}. Defaults to \code{FALSE}.}

\item{multiple_structures}{Logical indicating whether adding metadata should be applied for each plate separately,
because plates have different metadata structures. Will be applied  via user prompts for each plate separately. Defaults to \code{FALSE}.}

\item{direction}{A character vector specifying the orientation of the plate layout.
It can be either "horizontal" or "vertical".}

\item{...}{Additional arguments to be passed to \code{\link{read_plates}}, \code{\link{tidy_single_plate}},
\code{\link{tidy_plates_via_params}}, or \code{\link{tidy_plates_via_prompts}}.}
}
\value{
A list of cleaned data frames.
}
\description{
Cleans a list of data frames with different structures. This function reads data
from either a folder containing text files or from a list of data frames. It then cleans each
data frame using the function \code{tidy_plates_via_prompts()}.
}
\seealso{
\code{\link{read_plates}}, \code{\link{tidy_plates_via_prompts}}, \code{\link{tidy_plates_via_params}}, \code{\link{tidy_single_plate}}
}
