% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micss.R
\name{plot.icss}
\alias{plot.icss}
\title{plot.icss}
\usage{
\method{plot}{icss}(x, type = "std", title = NULL, ...)
}
\arguments{
\item{x}{An object with the output of \link{icss} or \link{micss}.}

\item{type}{Type of graphic. 3 possibilities: "std", which is the default,
plots the absolute value of the variable and the standard deviation; "var"
plots the squares of the variable and the variance; "res.std" plots
the standardized residuals.}

\item{title}{Title of the graphic.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
{No return value. It generates a plot the output of \link{micss} or \link{icss}}
}
\description{
Plots the output of the ICSS algorithm.
}
\examples{
set.seed(2)
e <- c(stats::rnorm(200),3*stats::rnorm(200))
o <- micss(e)
plot.icss(o,title="Example of the MICSS algorithm")
}
