% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gauss_lscv}
\alias{gauss_lscv}
\title{Least squares cross-validation for Gaussian kernel density estimation}
\usage{
gauss_lscv(x, Sigma, logweights, xsamp, dxsamp, mckern = TRUE)
}
\arguments{
\item{x}{\code{n} by \code{d} matrix of observations}

\item{Sigma}{smoothing positive-definite matrix}

\item{logweights}{log vector of weights}

\item{xsamp}{\code{n} by \code{d} random sample for Monte Carlo estimation of bias}

\item{dxsamp}{\code{n} vector of density for the points from \code{xsamp}}

\item{mckern}{logical; if \code{TRUE}, uses the kernel as sampler for Monte Carlo estimation}
}
\value{
least square criterion value
}
\description{
Least squares cross-validation for weighted Gaussian samples.
}
\keyword{internal}
