% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparameters.R
\name{get_hyperparams_from_df}
\alias{get_hyperparams_from_df}
\title{Split hyperparameters dataframe into named lists for each parameter}
\usage{
get_hyperparams_from_df(hyperparams_df, ml_method)
}
\arguments{
\item{hyperparams_df}{dataframe of hyperparameters with columns \code{param}, \code{value}, and \code{method}}

\item{ml_method}{machine learning method}
}
\value{
named list of lists of hyperparameters
}
\description{
Using \code{\link{get_hyperparams_list}} is preferred over this function.
}
\examples{
\dontrun{
hparams_df <- dplyr::tibble(
  param = c("alpha", "lambda", "lambda"),
  value = c(1, 0, 1),
  method = rep("glmnet", 3)
)
get_hyperparams_from_df(hparams_df, "glmnet")
}
}
\author{
Begüm Topçuoğlu, \email{topcuoglu.begum@gmail.com}

Kelly Sovacool, \email{sovacool@umich.edu}
}
\keyword{internal}
