% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparameters.R
\name{get_hyperparams_list}
\alias{get_hyperparams_list}
\title{Set hyperparameters based on ML method and dataset characteristics}
\usage{
get_hyperparams_list(dataset, method)
}
\arguments{
\item{dataset}{Data frame with an outcome variable and other columns as
features. Alternatively, the input can be in \code{TreeSummarizedExperiment}
format.}

\item{method}{ML method. Options: \code{c("glmnet", "rf", "rpart2", "svmRadial", "xgbTree")}.
\itemize{
\item glmnet: linear, logistic, or multiclass regression
\item rf: random forest
\item rpart2: decision tree
\item svmRadial: support vector machine
\item xgbTree: xgboost
}}
}
\value{
Named list of hyperparameters.
}
\description{
For more details see the vignette on \href{http://www.schlosslab.org/mikropml/articles/tuning.html}{hyperparameter tuning}.
}
\examples{
get_hyperparams_list(otu_mini_bin, "rf")
get_hyperparams_list(otu_small, "rf")
get_hyperparams_list(otu_mini_bin, "rpart2")
get_hyperparams_list(otu_small, "rpart2")
}
\author{
Kelly Sovacool, \email{sovacool@umich.edu}
}
