% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_allele_freqs.R
\name{get_allele_freqs}
\alias{get_allele_freqs}
\title{Get Allele Frequencies in pedtools Format}
\source{
\doi{10.1016/j.fsigss.2009.08.178}
\doi{10.1016/j.fsigen.2016.06.008}
\doi{10.1016/j.fsigen.2018.07.013}
}
\usage{
get_allele_freqs(region)
}
\arguments{
\item{region}{A data frame containing allele frequencies. The first column
should be "Allele" with allele designations, and subsequent columns
should be marker names with frequency values. Available built-in
databases: \code{\link{Argentina}}, \code{\link{Asia}},
\code{\link{Austria}}, \code{\link{BosniaHerz}}, \code{\link{China}},
\code{\link{Europe}}, \code{\link{Japan}}, \code{\link{USA}}.}
}
\value{
A named list where each element represents a genetic marker.
Each marker element is a named numeric vector with allele names and
their corresponding frequencies. This format is directly compatible
with \code{pedtools::setMarkers()}.
}
\description{
Converts allele frequency data from a data frame to a list format
compatible with the \pkg{pedtools} package for pedigree analysis.
}
\details{
The function transforms the data frame format (rows = alleles, columns =
markers) into the list format required by pedtools (one element per marker,
named by allele). This enables seamless integration with pedigree
likelihood calculations.
}
\examples{
# Convert Argentina database to pedtools format
freqs <- get_allele_freqs(Argentina)

# Check available markers
names(freqs)

# Use with pedtools
library(pedtools)
library(forrel)
x <- linearPed(2)
x <- setMarkers(x, locusAttributes = freqs[1:5])
}
\references{
Marino M, et al. (2009). "Allele frequencies of 15 STRs in an Argentine
population sample." Forensic Science International: Genetics Supplement
Series. \doi{10.1016/j.fsigss.2009.08.178}
}
\seealso{
\code{\link{Argentina}}, \code{\link{Europe}}, \code{\link{USA}} for
available frequency databases, \code{\link{sim_lr_genetic}} for using
these frequencies in simulations.
}
