% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl_helper_functions.R
\name{calculate_si_probability_matrix}
\alias{calculate_si_probability_matrix}
\title{Calculate Serial Interval Probability Matrix}
\usage{
calculate_si_probability_matrix(day_diffs, si_mean, si_sd, si_dist)
}
\arguments{
\item{day_diffs}{numeric matrix; matrix of day differences between each pair of cases, where element \code{[i,j]} represents days between case i and case j}

\item{si_mean}{numeric; mean of the serial interval distribution in days}

\item{si_sd}{numeric; standard deviation of the serial interval distribution in days}

\item{si_dist}{character; distribution type, either "gamma" or "normal"}
}
\value{
numeric matrix; matrix of transmission probabilities where element \code{[i,j]}
represents the probability that case j infected case i based on their
time difference and the serial interval distribution
}
\description{
Computes a matrix of transmission probabilities between all pairs of cases based
on their time differences and the specified serial interval distribution. Only
considers epidemiologically plausible transmission pairs (earlier to later cases).
}
\examples{
# Create sample day differences matrix
dates <- as.Date(c("2023-01-01", "2023-01-03", "2023-01-05"))
day_diffs <- create_day_diff_matrix(dates)

# Calculate probability matrix
prob_matrix <- calculate_si_probability_matrix(day_diffs, si_mean = 7, si_sd = 3, si_dist = "gamma")

}
