% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{fit_mixtur}
\alias{fit_mixtur}
\title{Fit the mixture model.}
\source{
The code for the 3-component model has been adapted from Matlab code
written by Paul Bays (https://bayslab.com) published under GNU General
Public License.
}
\usage{
fit_mixtur(
  data,
  model = "3_component",
  unit = "degrees",
  id_var = "id",
  response_var = "response",
  target_var = "target",
  non_target_var = NULL,
  set_size_var = NULL,
  condition_var = NULL,
  return_fit = FALSE
)
}
\arguments{
\item{data}{A data frame with columns containing (at the very least)
trial-level participant response and target values This data can either be
in degrees (1-360 or 1-180) or radians. If the 3-component mixture model is
to be fitted to the data, the data frame also needs to contain the values
of all non-targets. In addition, the model can be fit to individual
individual participants, individual set-sizes, and individual additional
conditions; if the user wishes for this, then the data frame should have
columns coding for this information.}

\item{model}{A string indicating the model to be fit to the data. Currently
the options are "2_component", "3_component", "slots", and "slots_averaging".}

\item{unit}{A string indicating the unit of measurement in the data frame:
"degrees" (measurement is in degrees, from 1 to 360); "degrees_180
(measurement is in degrees, but limited to 1 to 180); or "radians"
(measurement is in radians, from pi to 2 * pi, but could also be already in
the range -pi to pi).}

\item{id_var}{The quoted column name coding for participant id. If the data
is from a single participant (i.e., there is no id column) set to NULL.}

\item{response_var}{The quoted column name coding for the participants'
responses}

\item{target_var}{The quoted column name coding for the target value.}

\item{non_target_var}{The quoted variable name common to all columns (if
applicable) storing non-target values. If the user wishes to fit the
3-component mixture model, the user should have one column coding for each
non-target's value in the data frame. If there is more than one non-target,
each column name should begin with a common term (e.g., the "non_target"
term is common to the non-target columns "non_target_1", "non_target_2"
etc.), which should then be passed to the function via the
\code{non_target_var} variable.}

\item{set_size_var}{The quoted column name (if applicable) coding for the
set size of each response.}

\item{condition_var}{The quoted column name (if applicable) coding for the
condition of each response.}

\item{return_fit}{If set to TRUE, the function will return the log-likelihood
of the model fit, Akiakie's Information Criterion (AIC), Bayesian Information
Criterion (BIC), as well as the number of trials used in the fit.}
}
\value{
Returns a data frame with best-fitting parameters per participant (if
applicable), set-size (if applicable), and condition (if applicable). If
\code{return_fit} was set to \code{TRUE}, the data frame will also include
the log-likelihood value and information criteria of the model fit.
}
\description{
This is the function called by the user to fit either the two- or three-
component mixture model.
}
\examples{

# load the example data
data <- bays2009_full

# fit the 3-component mixture model ignoring condition
\donttest{
fit <- fit_mixtur(data = data,
                  model = "3_component",
                  unit = "radians",
                  id_var = "id",
                  response_var = "response",
                  target_var = "target",
                  non_target_var = "non_target",
                  set_size_var = "set_size",
                  condition_var = NULL)
}

}
