% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlfit-package.R
\docType{package}
\name{mlfit-package}
\alias{mlfit}
\alias{mlfit-package}
\title{mlfit: Iterative Proportional Fitting Algorithms for Nested Structures}
\description{
The Iterative Proportional Fitting (IPF) algorithm operates on count data. This package offers implementations for several algorithms that extend this to nested structures: 'parent' and 'child' items for both of which constraints can be provided. The fitting algorithms include Iterative Proportional Updating <https://trid.trb.org/view/881554>, Hierarchical IPF <doi:10.3929/ethz-a-006620748>, Entropy Optimization <https://trid.trb.org/view/881144>, and Generalized Raking <doi:10.2307/2290793>. Additionally, a number of replication methods is also provided such as 'Truncate, replicate, sample' <doi:10.1016/j.compenvurbsys.2013.03.004>.
}
\details{
To use this package, you need to:
\enumerate{
\item Specify your fitting problem with \code{\link[=ml_problem]{ml_problem()}}
\item Optionally, convert the fitting problem to a structure that can be
processed by the algorithms with \code{\link[=flatten_ml_fit_problem]{flatten_ml_fit_problem()}}; this is
helpful if you want to run the same fitting problem with multiple
algorithms and compare results.
\item Compute weights with one of the algorithms provided in this package with
\code{\link[=ml_fit]{ml_fit()}} or one of the specialized functions
\item Analyze weights or residuals, e.g. with \code{\link[=compute_margins]{compute_margins()}}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://mlfit.github.io/mlfit/}
  \item \url{https://github.com/mlfit/mlfit}
  \item Report bugs at \url{https://github.com/mlfit/mlfit/issues}
}

}
\author{
\strong{Maintainer}: Amarin Siripanich \email{amarin.siri@gmail.com} (Contributed `ml_replicate()`)

Authors:
\itemize{
  \item Kirill Müller (Creator of the package) [copyright holder]
}

Other contributors:
\itemize{
  \item Kay W. Axhausen (Advisor of Kirill Müller) [thesis advisor]
  \item Taha H. Rashidi (Advisor of Amarin Siripanich) [thesis advisor]
}

}
