% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/center.R
\name{center}
\alias{center}
\title{Centers variables for mixed effects models}
\usage{
center(
  dataset,
  x,
  grouping,
  type = "mean",
  standardize = FALSE,
  centerResult = FALSE
)
}
\arguments{
\item{dataset}{A dataset containing the variables to be centered and the grouping variable}

\item{x}{The variable or variables to be centered}

\item{grouping}{The variable or variables that define the grouping structure of the data}

\item{type}{a function to compute the grouping summary variable}

\item{standardize}{a logical value indicating whether x should be standardized before the computaion proceeds}

\item{centerResult}{a logical value indicating whether resulting grouping summary variable values should be centered at 0}
}
\value{
Creates two new variables in the data frame - a mean of the desired variable computed for each unique value in the grouping variable and a deviation score for each observation within the grouping variable that is that observation's raw score subtracted from the group mean.
}
\description{
Centers variables using the group-mean (person-mean) centering approach for mixed-effects models, and adds these variables to the data frame.
}
\examples{
data(instruction)
#Center student level socioeconomic status, "ses", around class mean "ses"
### To repress output: use invisible()
center(dataset = instruction, x = "ses", grouping = "classid")
#Center class-level variable teacher's mathematic prepartion,
# mathprep, around school mean "mathprep"
center(dataset = instruction, x = "mathprep", grouping = "schoolid")

}
\references{
Enders, C. & Tofighi, D. (2007). Centering predictor variables in cross-sectional multilevel models: A new look at an old problem. Psychological Methods, 12(2), 121–138
}
