% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpar.R
\name{plot.mlogit}
\alias{plot.mlogit}
\alias{plot.rpar}
\title{Plot of the distribution of estimated random parameters}
\usage{
\method{plot}{mlogit}(x, par = NULL, norm = NULL, type = c("density", "probability"), ...)

\method{plot}{rpar}(x, norm = NULL, type = c("density", "probability"), ...)
}
\arguments{
\item{x}{a `mlogit` or a `rpar` object,}

\item{par}{a subset of the random parameters ; if `NULL`, all the
parameters are selected,}

\item{norm}{the coefficient's name for the `mlogit` method or the
coefficient's value for the `rpar` method used for
normalization,}

\item{type}{the function to be plotted, whether the density or the
probability density function,}

\item{...}{further arguments, passed to `plot.rpar` for the
`mlogit` method and to `plot` for the `rpar` method.}
}
\description{
Methods for `rpar` and `mlogit` objects which provide a plot of the
distribution of one or all of the estimated random parameters
}
\details{
For the `rpar` method, one plot is drawn. For the `mlogit` method,
one plot for each selected random parameter is drawn.
}
\seealso{
[mlogit()] the estimation of random parameters logit
    models and [rpar()] for the description of `rpar` objects and
    [distribution] for functions which return informations about
    the distribution of random parameters.
}
\author{
Yves Croissant
}
\keyword{regression}
