% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_polars_backend.R
\name{as_polars_backend}
\alias{as_polars_backend}
\title{Convert to Polars Backend}
\usage{
as_polars_backend(data, streaming = FALSE, ...)
}
\arguments{
\item{data}{(\code{data.frame()} | \link[mlr3:DataBackend]{mlr3::DataBackend})\cr
See description.}

\item{streaming}{(\code{logical(1)})\cr
Whether the data should be only scanned (recommended for large data sets) and streamed with
every \link{DataBackendPolars} operation or loaded into memory completely.}

\item{...}{(\code{any})\cr
Additional arguments, passed to \link{DataBackendPolars}.}
}
\value{
\link{DataBackendPolars} or \link[mlr3:Task]{mlr3::Task}.
}
\description{
Converts to a \link{DataBackendPolars} using the \CRANpkg{polars} database, depending on the input type:
\itemize{
\item \code{data.frame}: Creates a new \link[mlr3:DataBackendDataTable]{mlr3::DataBackendDataTable} first using \code{\link[mlr3:as_data_backend]{mlr3::as_data_backend()}}, then proceeds
with the conversion from \link[mlr3:DataBackendDataTable]{mlr3::DataBackendDataTable} to \link{DataBackendPolars}.
\item \link[mlr3:DataBackend]{mlr3::DataBackend}: Creates a new \link{DataBackendPolars}.
}

There is no automatic connection to the origin file set.
If the data is obtained using scanning and the data is streamed, a \code{connector} can be set manually but is not required.
}
