% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_sbm.R
\name{fit_sbm}
\alias{fit_sbm}
\title{R/Rcpp function for fitting single level stochastic block model}
\usage{
fit_sbm(
  A,
  K,
  a0 = 0.5,
  b10 = 0.5,
  b20 = 0.5,
  n_iter = 1000,
  burn = 100,
  verbose = TRUE
)
}
\arguments{
\item{A}{An n x n symmetric adjacency matrix.}

\item{K}{The number of clusters specified a priori.}

\item{a0}{Dirichlet prior parameter for cluster sizes for clusters 1,...,K.}

\item{b10}{Beta distribution prior paramter for community connectivity.}

\item{b20}{Beta distribution prior parameter for community connectivity.}

\item{n_iter}{The number of total MCMC iterations to run.}

\item{burn}{The number of burn-in MCMC iterations to discard. The number of saved iterations will be n_iter - burn.}

\item{verbose}{Whether to print a progress bar to track MCMC progress. Defaults to true.}
}
\value{
A list of MCMC samples, including the MAP estimate of cluster indicators (z)
}
\description{
This function allows you to fit single level stochastic block models.
}
\examples{
data(AL)
fit <- fit_sbm(AL[[1]],3)
}
\keyword{Bayesian}
\keyword{Gibbs}
\keyword{MLSBM}
\keyword{SBM}
\keyword{networks}
