% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_check_cov_struct_nesting}
\alias{h_check_cov_struct_nesting}
\title{Ensure Two Models' Covariance Structures Are Nested}
\usage{
h_check_cov_struct_nesting(model_basic, model_augmented)
}
\arguments{
\item{model_basic, model_augmented}{(\code{mmrm_tmb_formula_parts})\cr the
\code{formula_parts} element of an \code{mmrm} model fit.}
}
\value{
\code{"identical"} if \code{model_basic} and \code{model_augmented} have the same
covariance structure. \code{"nesting"} if the covariance structure of
\code{model_basic} is a special case of the covariance structure of
\code{model_augmented}.
}
\description{
Throws an error if the covariance structure of \code{model_basic} isn't the same
as or a special case of the covariance structure of \code{model_augmented}.
}
\details{
The check for "nesting" is a check against a mathematically determined
hierarchy of the available \link{cov_types}: if restricting an aspect of a
covariance structure can result in another covariance structure, the latter
structure is nested within the former structure.

For upstream coding brevity, this function accepts the \code{formula_parts}
element of two \code{mmrm} model fits rather than \code{mmrm} objects. Such objects are
of class \code{mmrm_tmb_formula_parts}.
}
\keyword{internal}
