% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghzip.R
\name{ghzip}
\alias{ghzip}
\title{Creates a ZIP file or directory with files}
\usage{
ghzip(files, dest = NULL)
}
\arguments{
\item{files}{\code{ghdecompose} object or character: list of files to copy}

\item{dest}{character: ZIP file name of destination directory (default: \code{NULL})}
}
\value{
the name of the destination directory or the ZIP file
}
\description{
\code{ghzip} creates a ZIP file (if \code{dest} has an extension \code{zip}) or copies to the destination directory.
If \code{dest} is \code{NULL} then a temporary directory will be used.
Please note that neither the ZIP file is deleted nor the target directory is cleaned beforehand
if it already exists.
}
\examples{
if (interactive()) {
  zipfile <- tempfile(fileext='.zip')
  files   <- list.files(system.file(package="mmstat4"), recursive=TRUE)
  ghzip(files, zipfile)
}
}
