% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr_boxplots.R
\name{plot_comm_div}
\alias{plot_comm_div}
\title{Plot alpha-, beta-, and gamma-scale biodiversity statistics for a MoB analysis}
\usage{
plot_comm_div(
  comm_div,
  index = NULL,
  multi_panel = FALSE,
  col = c("#FFB3B5", "#78D3EC", "#6BDABD", "#C5C0FE", "#E2C288", "#F7B0E6", "#AAD28C"),
  cex.axis = 1.2,
  ...
)
}
\arguments{
\item{comm_div}{a table that is output by \code{calc_comm_div} that has the
sample (alpha) and group (gamma) level statistics}

\item{index}{The biodiversity statistics that should be plotted.
See \code{\link{calc_comm_div}} for information on the indices. By default there
is one figure for each index, with panels for alpha- and gamma-scale results
as well as for beta-diversity when applicable.}

\item{multi_panel}{A logical variable. If \code{multi_panel = TRUE} then a 
multipanel plot is produced, which shows observed, rarefied, and asymptotic 
species richness and S_PIE at the alpha- and gamma-scale.
This set of variables conveys a comprehensive picture of the underlying 
biodiversity changes.}

\item{col}{a vector of colors for the groups, set to NA if no color is
preferred}

\item{cex.axis}{The magnification to be used for axis annotation relative to
the current setting of cex. Defaults to 1.2.}

\item{...}{additional arguments to provide to \code{boxplot}, \code{points},
and confidence interval functions}
}
\description{
Plots the community diversity metrics from produced by the function 
\code{calc_comm_div}. The p-value for each statistic
is displayed in the plot title if applicable.
}
\details{
The user may specify which results to plot or simply to plot 
all the results.
}
\examples{
library(dplyr)
data(tank_comm)
data(tank_plot_attr)
indices <- c('N', 'S', 'S_C', 'S_n', 'S_PIE')
tank_div <- tibble(tank_comm) \%>\% 
  group_by(group = tank_plot_attr$group) \%>\% 
  group_modify(~ calc_comm_div(.x, index = indices, effort = 5,
                               extrapolate = TRUE))
# plot the community metrics                                 
plot_comm_div(tank_div, index = "S")
plot_comm_div(tank_div, index = "S_n")
# or plot all of the indices at once with
plot_comm_div(tank_div)
}
\author{
Felix May, Xiao Xiao, and Dan McGlinn
}
