% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps_critical_edges.R
\name{edge_contribution}
\alias{edge_contribution}
\title{List edge contribution}
\usage{
edge_contribution(net, motif, lvl_attr = c("sesType"), level = -1)
}
\arguments{
\item{net}{network object}

\item{motif}{motif identifier}

\item{lvl_attr}{character vector specifying the attribute name where level
information is stored in \code{net}.}

\item{level}{level of the dyads which shall be considered, or -1 if the level
shall be determined automatically.}
}
\value{
data frame with three columns, listing edges and their contribution
  to motifs described by the motif identifier in descending order
}
\description{
List gaps ordered by contribution to a motif. This is a list of ties together
with the number of motifs of a given class the dyad would generate by being
flipped. This is a generalisation of \code{motifr::identify_gaps()} and
\code{motifr::criticial_dyads()}.
}
\details{
The level parameter determines on which level of the network edge
contributions are analysed. Per default, when \code{level = -1}, the first
level in the motif which provides exactly two nodes is selected. Use this
parameter to specify a level manually. The procedure for determining the
level is the same as for the Actor's Choice Model, cf. vignette.

Note that this only works for undirected graphs. Regardless of whether the
input graph is directed it is treated as undirected graph.
}
\examples{
\dontrun{
head(edge_contribution(ml_net, "1,2[I.C]"))
}
}
