% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_motifs.R
\name{list_motifs}
\alias{list_motifs}
\title{Lists motifs of a given class or all motifs with a given signature}
\usage{
list_motifs(net, identifier, lvl_attr = "sesType", directed = NULL)
}
\arguments{
\item{net}{network object}

\item{identifier}{motif identifier string (with or without class, see above)}

\item{lvl_attr}{character vector specifying the attribute name where level
information is stored in \code{net}.}

\item{directed}{whether the graph shall be treated as a directed graph. Per
default (\code{NULL}), this is determined automatically using the structure
of the provided network object}
}
\value{
data frame with one row for each motif
}
\description{
Returns a dataframe with one row for each instance of the motif specified by
the given motif identifier string. If the identifier string specifies a motif
class, e.g. \code{1,2[I.A]}, then only motifs of the given class are returned.
If the identifier string specifies a signature, e.g. \code{1,2}, then a full
list of all motifs of this signature is returned. In the latter case, the
dataframe contains an additional column stating the classes of the motifs.
The naming scheme of the columns is as follows: Each column is called
\code{levelA_nodeB} where \code{A} is the \code{lvl_attr} of the nodes in the column
and \code{B} the index of the nodes among the nodes on the same level. This
index stems from the internal order of the nodes and does not carry any
specific meaning.
}
\examples{
\dontrun{
head(list_motifs(ml_net, "1,2[I.C]", directed = FALSE))
}
}
