% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vital_status.R
\name{vital_status}
\alias{vital_status}
\title{Determine vital status at end of follow-up depending on pat_status - tidyverse version}
\usage{
vital_status(
  wide_df,
  status_var = "p_status",
  life_var_new = "p_alive",
  check = TRUE,
  as_labelled_factor = FALSE
)
}
\arguments{
\item{wide_df}{dataframe in wide format}

\item{status_var}{Name of the patient status variable that was previously created. Default is p_status.}

\item{life_var_new}{Name of the newly calculated variable for patient vital status. Default is p_alive.}

\item{check}{Check newly calculated variable life_var_new by printing frequency table. Default is TRUE.}

\item{as_labelled_factor}{If true, output life_var_new as labelled factor variable. Default is FALSE.}
}
\value{
wide_df
}
\description{
Determine vital status at end of follow-up depending on pat_status - tidyverse version
}
\examples{
#load sample data
data("us_second_cancer")

#prep step - make wide data as this is the required format
usdata_wide <- us_second_cancer \%>\%
                    msSPChelpR::reshape_wide_tidyr(case_id_var = "fake_id", 
                    time_id_var = "SEQ_NUM", timevar_max = 10)
                    
#prep step - calculate p_spc variable
usdata_wide <- usdata_wide \%>\%
                 dplyr::mutate(p_spc = dplyr::case_when(is.na(t_site_icd.2)   ~ "No SPC",
                                                       !is.na(t_site_icd.2)   ~ "SPC developed",
                                                       TRUE ~ NA_character_)) \%>\%
                 dplyr::mutate(count_spc = dplyr::case_when(is.na(t_site_icd.2)   ~ 1,
                                                              TRUE ~ 0))
                                                              
#prep step - create patient status variable
usdata_wide <- usdata_wide \%>\%
                  msSPChelpR::pat_status(., fu_end = "2017-12-31", dattype = "seer",
                                         status_var = "p_status", life_var = "p_alive.1",
                                         birthdat_var = "datebirth.1", lifedat_var = "datedeath.1")
 
#now we can run the function
msSPChelpR::vital_status(usdata_wide, 
                        status_var = "p_status",
                        life_var_new = "p_alive_new", 
                        check = TRUE, 
                        as_labelled_factor = FALSE)

}
