% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{generate.intersections.mst.knn}
\alias{generate.intersections.mst.knn}
\title{Performs the intersections between MST y kNN graphs}
\usage{
generate.intersections.mst.knn(nodes.list, distance.matrix, suggested.k)
}
\arguments{
\item{nodes.list}{A vector with a subset of objects (nodes) of the data matrix for which the MST y kNN graphs must be generated.}

\item{distance.matrix}{A distance matrix between each pair of elements in \code{nodes.list}. It is used as the edges costs to generate MST y kNN graphs.}

\item{suggested.k}{A numeric value representing the number of nearest neighbors to consider to generate the \emph{k}NN graph.}
}
\value{
A list with the elements
\item{cc}{A numeric value representing the number of connected components (cc) generated after graphs intersection.}
\item{subgraphs}{ A list where each item contains the nodes of the connected components (cc) generated.}
\item{ccgraph}{A object of class "igraph" which is a network with each connected components (cc) generated.}
}
\description{
This function performs a graph partition based on the intersection of the edges of two proximity graphs: MST and kNN.
}
\author{
Mario Inostroza-Ponta, Jorge Parraga-Alava, Pablo Moscato
}
\keyword{internal}
