% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mulset.R
\name{mulset}
\alias{mulset}
\title{A mulset function}
\usage{
mulset(data, exclude = NULL, include = c("samples", "samples_count",
  "datapoints"), maxIntersections = NULL, hashMethod = "md5")
}
\arguments{
\item{data}{Data frame containing your data}

\item{exclude}{Vector containing  one  or  more  variable  names  from \code{names(data)}}

\item{include}{List of attributes which will be shown in results. Possible values are: c("samples", "samples_count", "datapoints"). If parameter is set to NULL only c("features", "feature_count") will be returned.}

\item{maxIntersections}{Maximum number of unique datasets to generate, if NULL all datasets will be generated}

\item{hashMethod}{Hashing method to use for unique sets identification. Available choices: md5(default), sha1, crc32, sha256, sha512, xxhash32, xxhash64, murmur32}
}
\value{
If any intersections are found it returns a list that contains all available multi-set intersections
You can convert this to data-frame following example provided or use it as it is.
}
\description{
\code{mulset()} returns all multi-set intersections
}
\details{
This function allows you to generate specific type of multi-set intersections.
It searches for multi set intersections between rows and column identifiers. If no NA values are present only 1 dataset is returned as expected.
}
\examples{
data(mulsetDemo)
print(head(mulsetDemo))
resamples <- mulset(mulsetDemo, exclude = c("outcome", "age", "gender"), maxIntersections = 250)
## Loop through returned list or convert it to data-frame
## resamplesFrame <- as.data.frame(t(sapply(resamples,c)))
}
\keyword{data}
\keyword{intersection,}
\keyword{missing}
\keyword{mulset,}
\keyword{multi-set}
\keyword{table}
