% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiRDPGtest.R
\name{nullestimation}
\alias{nullestimation}
\title{\code{nullestimation} calculates the estimation under the null hypothesis}
\usage{
nullestimation(A, d)
}
\arguments{
\item{A}{List of symmetric A matrices}

\item{d}{Dimension of the latent space}
}
\value{
Returns a list of the following\cr
 \tabular{ll}{
          \code{U}        \tab The common latent space vectors. U in R^{n x d}\cr
          \code{Lambda}   \tab List of Lambdas. Each is a positive diagonal matrix of size d x d.
}
}
\description{
\code{nullestimation} calculates the estimation under the null hypothesis
}
\examples{
#simulate data
U <- matrix(0, nrow=20, ncol=3)
U[,1] <- 1/sqrt(20)
U[,2] <- rep(c(1,-1), 10)/sqrt(20)
U[,3] <- rep(c(1,1,-1,-1), 5)/sqrt(20)

L<-list(diag(c(11,6,2)),diag(c(15,4,1)))
A <- list()
for(i in 1:2){
  P <- U\%*\%L[[i]]\%*\%t(U)
  A[[i]] <-apply(P,c(1,2),function(x){rbinom(1,1,x)})
  A[[i]][lower.tri(A[[i]])]<-t(A[[i]])[lower.tri(A[[i]])]
}

#fit model
nullestimation(A,3)


}
\seealso{
\code{\link{multiRDPG}}
}
\author{
Agnes Martine Nielsen (agni@dtu.dk)
}
