% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_3_fit_p.R
\name{fit_p}
\alias{fit_p}
\title{Step 3: Optimizing parameters to fit real data}
\usage{
fit_p(
  estimate,
  data,
  colnames,
  behrule,
  ids = NULL,
  funcs = NULL,
  priors = NULL,
  settings = NULL,
  models,
  algorithm,
  lowers,
  uppers,
  control,
  ...
)
}
\arguments{
\item{estimate}{Estimate method that you want to use, 
see \link[multiRL]{estimate}}

\item{data}{A data frame in which each row represents a single trial,
see \link[multiRL]{data}}

\item{colnames}{Column names in the data frame,
see \link[multiRL]{colnames}}

\item{behrule}{The agent’s implicitly formed internal rule,
see \link[multiRL]{behrule}}

\item{ids}{The Subject ID of the participant whose data needs to be fitted.}

\item{funcs}{The functions forming the reinforcement learning model,
see \link[multiRL]{funcs}}

\item{priors}{Prior probability density function of the free parameters,
see \link[multiRL]{priors}}

\item{settings}{Other model settings, 
see \link[multiRL]{settings}}

\item{models}{Reinforcement Learning Models}

\item{algorithm}{Algorithm packages that multiRL supports, 
see \link[multiRL]{algorithm}}

\item{lowers}{Lower bound of free parameters in each model.}

\item{uppers}{Upper bound of free parameters in each model.}

\item{control}{Settings manage various aspects of the iterative process,
see \link[multiRL]{control}}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
An S3 object of class \code{multiRL.fitting}.
  A \code{List} containing, for each model, the estimated optimal parameters
  and associated model fit metrics.
}
\description{
Step 3: Optimizing parameters to fit real data
}
\section{Example}{
 
\preformatted{ # fitting
 fitting.MLE <- multiRL::fit_p(
   estimate = "MLE",
  
   data = multiRL::TAB,
   colnames = list(
     object = c("L_choice", "R_choice"), 
     reward = c("L_reward", "R_reward"),
     action = "Sub_Choose"
   ),
   behrule = list(
     cue = c("A", "B", "C", "D"),
     rsp = c("A", "B", "C", "D")
   ),
  
   models = list(multiRL::TD, multiRL::RSTD, multiRL::Utility),
   settings = list(name = c("TD", "RSTD", "Utility")),
  
   algorithm = "NLOPT_GN_MLSL",
   lowers = list(c(0, 0), c(0, 0, 0), c(0, 0, 0)),
   uppers = list(c(1, 5), c(1, 1, 5), c(1, 5, 1)),
   control = list(core = 10, iter = 100)
 )
}
}

