\name{plot_binary_TSP}
\alias{plot_binary_TSP}
\title{
Plot binary rule-based heatmaps
}
\description{
\code{plot_binary_TSP}
Plot binary heatmaps for datasets based on one-vs-rest multiclass top score pairs classifier

}
\usage{
plot_binary_TSP(Data,
                classifier,
                ref              = NULL,
                prediction       = NULL,
                platform         = NULL,
                classes          = NULL,
                platforms_ord    = NULL,
                top_anno         = c("ref", "prediction", "platform")[1],
                title            = "",
                binary_col       = c("white", "black", "gray"),
                ref_col          = NULL,
                pred_col         = NULL,
                platform_col     = NULL,
                show_ref         = TRUE,
                show_predictions = TRUE,
                show_platform    = TRUE,
                show_scores      = TRUE,
                show_rule_name   = TRUE,
                legend           = TRUE,
                cluster_cols     = TRUE,
                cluster_rows     = TRUE,
                anno_height      = 0.03,
                score_height     = 0.03,
                margin           = c(0, 5, 0, 5))
}
\arguments{
\item{Data}{
a matrix, dataframe, where samples as columns and row as features/genes. Can also take ExpressionSet, or data_object generated by ReadData function.
}
  \item{classifier}{
  classifier as a OnevsrestScheme_TSP object, generated by train_one_vs_rest_TSP function
}
  \item{ref}{
Optional vector with the reference labels. Ref labels in data_object will be used if not ref input provided. For ExpressionSet, the name of the variable in the pheno data.
}
  \item{prediction}{
Optional dataframe with class "OneVsRestTSP prediction" generated by predict_one_vs_rest_TSP function with the scores and the predicted labels.
}
  \item{platform}{
Optional vector with the platform/study labels or any additional annotation. Platform labels in data_object will be used if no platform input provided. For ExpressionSet, the name of the variable in the pheno data.
}
  \item{classes}{
Optional vector with the class names. This will determine which classes will be plotted and in which order. It is not recommended to use both "classes" and "platforms_ord" arguments together.
}
  \item{platforms_ord}{
Optional vector with the platform/study names. This will determine which platform/study will be plotted and in which order. This will be used when top_anno="platform". It is not recommended to use both "classes" and "platforms_ord" arguments together.
}
  \item{top_anno}{
Determine the top annotation level. Samples will be grouped based on the top_anno. Input can be one of three options: "ref", "prediction", "platform". Default is "ref".
}
  \item{title}{
Carachter input as a title for the whole heatmap. Default is "".
}
  \item{binary_col}{
vector determines the colors of the binary heatmap. Default is c("white", "black", "gray"). First color for the color when the rule is false in the sample. Second color for the color when the rule is true. Third color is for NAs.
}
  \item{ref_col}{
optional named vector determines the colors of classes for the reference labels. Default is NULL. Vector names should match with the ref labels.
}
  \item{pred_col}{
optional named vector determines the colors of classes for the prediction labels. Default is NULL. Vector names should match with the prediction labels in the prediction labels.
}
  \item{platform_col}{
optional named vector determines the colors of platforms/study labels. Default is NULL. Vector names should match with the platforms/study labels.
}
  \item{show_ref}{
logical. Determines if the ref labels will be plotted or not. If the top_anno argument is "ref" then show_ref will be ignored.
}
  \item{show_predictions}{
logical. Determines if the prediction labels will be plotted or not. If the top_anno argument is "prediction" then show_predictions will be ignored.
}
  \item{show_platform}{
logical. Determines if the platform/study labels will be plotted or not. If the top_anno argument is "platform" then show_platform will be ignored.
}
  \item{show_scores}{
logical. Determines if the prediction scores will be plotted or not.
}
  \item{show_rule_name}{
logical. Determines if the rule names will be plotted on the left side of the heatmapp or not.
}
  \item{legend}{
logical. Determines if a legend will be plotted under the heatmap.
}
  \item{cluster_cols}{
logical. Clustering the samples in each class (i.e. not all samples in the cohort) based on the binary rules for that class. If top_anno is "platform" then the rules from all classes are used to cluster the samples in each platform.
}
  \item{cluster_rows}{
logical. Clustering the rules in each class.
}
  \item{anno_height}{
Determines the height of the annotations. It is recommended not to go out of this range 0.01<height<0.1. Default is 0.03.
}
  \item{score_height}{
Determines the height of the score bars. It is recommended not to go out of this range 0.01<height<0.1. Default is 0.03.
}
  \item{margin}{
Determines the margins of the heatmap. Default is c(0, 5, 0, 5).
}
}

\value{
returns a heatmap plot for the binary rule
}

\author{
Nour-al-dain Marzouka <nour-al-dain.marzouka at med.lu.se>
}

\examples{
# random data
Data <- matrix(runif(10000), nrow=100, ncol=100,
               dimnames = list(paste0("G",1:100), paste0("S",1:100)))

# labels
L <- sample(x = c("A","B","C"), size = 100, replace = TRUE)

# study/platform
P <- sample(c("P1","P2"), size = 100, replace = TRUE)

object <- ReadData(Data = Data,
             Labels = L,
                   Platform = P)

# not to run
# switchBox package from Bioconductor is needed
# Visit their website or install switchBox package using:
# if(!requireNamespace("switchBox", quietly = TRUE)){
#       if (!requireNamespace('BiocManager', quietly = TRUE)) {
#       install.packages('BiocManager')
#      }
#      BiocManager::install('switchBox')", call. = FALSE)
#  }

#filtered_genes <- filter_genes_TSP(data_object = object,
#                                   filter = "one_vs_rest",
#                                  platform_wise = FALSE,
#                                  featureNo = 10,
#                                  UpDown = TRUE,
#                                  verbose = FALSE)

# training
# classifier <- train_one_vs_rest_TSP(data_object = object,
#                              filtered_genes = filtered_genes,
#                              k_range = 2:50,
#                              include_pivot = FALSE,
#                              one_vs_one_scores = FALSE,
#                              platform_wise_scores = FALSE,
#                              seed = 1234,
#                              verbose = FALSE)

# results <- predict_one_vs_rest_TSP(classifier = classifier,
#                                   Data = object,
#                                   tolerate_missed_genes = TRUE,
#                                   weighted_votes = TRUE,
#                                   verbose = FALSE)

# Confusion Matrix and Statistics on training data
#  caret::confusionMatrix(data = factor(results$max_score, levels = unique(L)),
#                         reference = factor(L, levels = unique(L)),
#                         mode="everything")

# plot_binary_TSP(Data = object, classes=c("A","B","C"),
#                 classifier = classifier,
#                 prediction = results,
#                 title = "Test")
}
