% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mland_save.R
\name{mland_save}
\alias{mland_save}
\title{Saves a 'MultiLand' or 'MultiLandMetrics' object}
\usage{
mland_save(
  x,
  name = NULL,
  gdal = c("COMPRESS=DEFLATE", "PREDICTOR=2", "ZLEVEL=9"),
  dir = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{Object of class 'MultiLand' or 'MultiLandMetrics'.}

\item{name}{If \code{x} is an object of class 'MultiLand', the name of the zip file where
files will be saved (without the '.zip'). If \code{x} is an object of class 'MultiLandMetrics',  the name of the R file (.rds). If NULL (default),
the name will be 'mland_' or 'mlandmetrics_' + a large random number.}

\item{gdal}{GeoTiff creation options for rasters (\href{https://gdal.org/en/stable/drivers/raster/gtiff.html}{GeoTiff file format}).
\code{\link[=mland_save]{mland_save()}} uses the following compression options: c("COMPRESS=DEFLATE", "PREDICTOR=2", "ZLEVEL=9"). Only relevant
if \code{x} is an object of class 'MultiLand'.}

\item{dir}{Path to the export directory. This must be specified explicitly.
To export to the current directory, use \code{dir = getwd()}. Otherwise, provide
a valid path to an existing directory, ensuring it does not end with "/".}

\item{verbose}{Print messages in the console? Default is TRUE.}

\item{...}{If \code{x} is an object of class 'MultiLand', \code{...} should depict other arguments passed to
\link[terra:writeRaster]{terra::writeRaster}, the function to write raster layers (from intersections and plain raster layers).
Otherwise, if \code{x} is an object of class 'MultiLandMetrics', \code{...} should depict other arguments passed
to \code{\link[=save]{save()}}. See Details.}
}
\value{
If \code{x} is an object of class 'MultiLand', a zip file or a directory containing all
information regarding the 'MultiLand' object provided in 'x'. Otherwise, if \code{x} is an object of
class 'MultiLandMetrics', the function will export the R object as if it was exported as a
regular R object with \code{\link[=saveRDS]{saveRDS()}}.
}
\description{
Exports an object of class 'MultiLand' to be read in the future with \code{\link[=mland_load]{mland_load()}}, or
an object of class 'MultiLandMetrics' as if it was saved with \code{\link[=saveRDS]{saveRDS()}}.
}
\details{
'MultiLand' objects should be exported with this function rather than exporting as an
external representation of R objects with \code{\link[=saveRDS]{saveRDS()}}. This is because objects of classes
'SpatVector' and 'SpatRaster' (from package terra) contained inside a 'MultiLand'
object cannot be exported as regular R objects. The exported object will be a zip file,
and can be loaded again into an R session with \code{\link[=mland_load]{mland_load()}}.

Relevant arguments can be passed to the function \link[terra:writeRaster]{terra::writeRaster}, which is used to write
raster layers from a 'MultiLand' object. Particularly, in the argument \code{gdal} one can specify
relevant options regarding raster compression. This may reduce raster sizes significantly. Definition
of some other arguments inside \link[terra:writeRaster]{terra::writeRaster} may affect exportation of raster layer
objects, in the context of a 'MultiLand' object.

Objects of class 'MultiLandMetrics', instead, do not contain 'SpatVector' or 'SpatRaster' objects
and can be exported as regular R objects with \code{\link[=saveRDS]{saveRDS()}}. The user may use \code{\link[=saveRDS]{saveRDS()}} or
\code{\link[=mland_save]{mland_save()}}, and the outcome will be identical.
}
\examples{
\donttest{
# Load MultiLand object
mland_obj <- system.file("extdata", "ernesdesign.zip", package = "multilandr")
ernesdesign2 <- mland_load(mland_obj)

# Save it again, in temporary directory for this example and with a given name
mland_save(ernesdesign2, name = "mland_example", dir = tempdir())

# Remove file for this example
unlink(file.path(tempdir(), "mland_example.zip"))

# Save it again but defining a higher compression for raster layers
mland_save(ernesdesign2, gdal = "COMPRESS=DEFLATE", name = "mland_example", dir = tempdir())

# Remove file for this example
unlink(file.path(tempdir(), "mland_example.zip"))

# Loads a MultiLandMetrics object previously generated with mland_metrics()
mlm_obj <- system.file("extdata", "ed_metrics.rds", package = "multilandr")
ed_metrics2 <- mland_load(mlm_obj)

# Save it again. In this case, mland_save() is the same as using saveRDS()
mland_save(ed_metrics2, dir = tempdir(), name = "mlandmetrics_example")

unlink(file.path(tempdir(), "mlandmetrics_example.rds"))
}
}
\seealso{
\code{\link[=mland_load]{mland_load()}}, \code{\link[=mland]{mland()}}, \code{\link[=mland_metrics]{mland_metrics()}}
}
