% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{brms_sampler}
\alias{brms_sampler}
\title{Sample from a Bayesian Regression Model}
\usage{
brms_sampler(fits, newdata = NULL, indices = NULL, ...)
}
\arguments{
\item{fits}{The fitted 'BRMS' model model from which to draw samples.}

\item{newdata}{A data.frame containing new inputs from which to sample
responses. If NULL, defaults to the data used to estimate fit.}

\item{indices}{The coordinates of the response from which we want to sample.}

\item{...}{Additional arguments to pass to \code{posterior_predict} in the 'brms'
package.}
}
\value{
A data.frame containing a single posterior predictive sample at each
of the newdata rows passed into a fitted BRMS model. Each column
corresponds to one outcome variable, each row to the associated row in the
newdata input..
}
\description{
This samples from the posterior predictive for each component in
a multiresponse Bayesian Regression model.
}
