% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_data.R
\name{spline_fun}
\alias{spline_fun}
\title{Generate Random Spline}
\usage{
spline_fun(D = 2, knots = NULL, h_ix = seq_len(10), ...)
}
\arguments{
\item{D}{The number random spline functions to generate internally.}

\item{knots}{The location of knots to use in the spline functions. Defaults
to -4, -2, 0, 2, 4.}

\item{h_ix}{The locations along which to generate the underlying spline
function.}

\item{...}{Additional arguments to pass to \code{rnorm} during the random noise
generation for each call of the returned function.}
}
\value{
A function that can be used to sample points along the random spline
functions. Takes argument 'x' giving the input to the spline and returns a
D-dimensional response y giving random samples for each of the D splines..
}
\description{
This generates random spline functions. It is used in the toy nonlinear
dataset created in \code{demo_spline()}. This is not necessary for the essential
multimedia workflow, it is only exported for potential independent interest.
}
\seealso{
demo_spline
}
