% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsets.R
\name{subsetspectrum}
\alias{subsetspectrum}
\title{Subset varieties for all subsets of a fixed size}
\usage{
subsetspectrum(
  set,
  subsetcard,
  simplify = TRUE,
  mode = "tn",
  edo = 12,
  rounder = 10
)
}
\arguments{
\item{set}{The scale to find subsets of, as a numeric vector}

\item{subsetcard}{Single integer defining the cardinality of subsets to consider}

\item{simplify}{Should "inversions" of a subset be ignored? Boolean, defaults to \code{TRUE}}

\item{mode}{String \code{"tn"} or \code{"tni"}. When defining subset shapes, use transposition or transposition
& inversion to reduce the number of shapes to consider? Defaults to \code{"tn"}.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
A list whose length matches the number of distinct subset shapes (given the chosen options).
Each entry of the list is a matrix displaying the varieties of some particular subset type.
}
\description{
Applies \code{\link[=subset_varieties]{subset_varieties()}} not just to a particular subset shape but to all possible subset shapes
given a fixed cardinality. For example, finds the specific varieties of \emph{all} trichordal subsets of
the major scale, not than just the varieties of the tonal triad. Comparable to \code{\link[=intervalspectrum]{intervalspectrum()}}
but for subsets larger than dyads.
}
\details{
The parameter \code{simplify} lets you control whether to consider different "inversions" of a subset shape
independently. For instance, with \code{simplify=TRUE}, only root position triads (0, 2, 4) would be considered;
but with \code{simplify=FALSE}, the first inversion (0, 2, 5) and second inversion (0, 3, 5) subset shapes would
also be displayed.
}
\examples{
c_major_scale <- c(0, 2, 4, 5, 7, 9, 11)
subsetspectrum(c_major_scale, 3)
subsetspectrum(c_major_scale, 3, simplify=FALSE)
subsetspectrum(c_major_scale, 3, mode="tni") # Note the absence of a "0, 2, 3" matrix

}
