% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_measure.R
\name{measure}
\alias{measure}
\title{Measure constructor.}
\usage{
measure(
  number,
  notes,
  beats = 4,
  beatType = 4,
  keySignature = 0,
  mode = "major"
)
}
\arguments{
\item{number}{Integer (>0), measure number.}

\item{notes}{List of 'note' objects. Sum of notes durations should be compatible
with the measure time signature}

\item{beats}{Integer (>0), time signature is beats/beatType (default 4/4).}

\item{beatType}{Integer (>0), time signature is beats/beatType (default 4/4).}

\item{keySignature}{Integer, representing the number of flats (<0) or sharps (>0).}

\item{mode}{Character, mode. Can be one of  major, minor, dorian, phrygian, lydian,
mixolydian, aeolian, ionian, locrian, and none.}
}
\value{
An object of class 'measure'.
}
\description{
Creates a new instance of a 'measure' object
}
\examples{
notes=list(note(p=pitch('Db5'),d=duration(2)),note(p=pitch('B5'),d=duration(2)))
m <- measure(number=1,notes=notes)
}
