% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nFunNNmodel.R
\name{nFunNNmodel}
\alias{nFunNNmodel}
\title{Nonlinear FPCA using neural networks}
\usage{
nFunNNmodel(
  X_ob,
  t_grid,
  t_grid_est,
  L_smooth,
  L,
  J,
  K,
  R,
  lr = 0.001,
  batch_size,
  n_epoch
)
}
\arguments{
\item{X_ob}{A \code{matrix} denoting the observed data.}

\item{t_grid}{A \code{vector} denoting the observation time grids on \code{[0, 1]}.}

\item{t_grid_est}{A \code{vector} denoting the time grids that have to be predicted on \code{[0, 1]}.}

\item{L_smooth}{An \code{integer} denoting the number of B-spline basis functions that used to smooth the observed data for the computation of the loss function.}

\item{L}{An \code{integer} denoting the number of B-spline basis functions for the parameters in the network.}

\item{J}{An \code{integer} denoting the number of neurons in the first hidden layer.}

\item{K}{An \code{integer} denoting the number of principal components.}

\item{R}{An \code{integer} denoting the number of neurons in the third hidden layer.}

\item{lr}{A scalar denoting the learning rate. (default: 0.001)}

\item{batch_size}{An \code{integer} denoting the batch size.}

\item{n_epoch}{An \code{integer} denoting the number of epochs.}
}
\value{
A \code{list} containing the following components:
\item{model}{The resulting neural network trained by the observed data.}
\item{loss}{A \code{vector} denoting the averaged loss in each epoch.}
\item{Comp_time}{An object of class "difftime" denoting the computation time in seconds.}
}
\description{
Nonlinear functional principal component analysis using a transformed functional autoassociative neural network.
}
\examples{
\donttest{
n <- 2000
m <- 51
t_grid <- seq(0, 1, length.out = m)
m_est <- 101
t_grid_est <- seq(0, 1, length.out = m_est)
err_sd <- 0.1
Z_1a <- stats::rnorm(n, 0, 3)
Z_2a <- stats::rnorm(n, 0, 2)
Z_a <- cbind(Z_1a, Z_2a)
Phi <- cbind(sin(2 * pi * t_grid), cos(2 * pi * t_grid))
Phi_est <- cbind(sin(2 * pi * t_grid_est), cos(2 * pi * t_grid_est))
X <- Z_a \%*\% t(Phi)
X_to_est <- Z_a \%*\% t(Phi_est)
X_ob <- X + matrix(stats::rnorm(n * m, 0, err_sd), nr = n, nc = m)
L_smooth <- 10
L <- 10
J <- 20
K <- 2
R <- 20
nFunNN_res <- nFunNNmodel(X_ob, t_grid, t_grid_est, L_smooth,
L, J, K, R, lr = 0.001, n_epoch = 1500, batch_size = 100)}
}
