% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_netmhc2pan_bin.R
\name{download_netmhc2pan_bin}
\alias{download_netmhc2pan_bin}
\title{Download the NetMHCIIpan binary}
\usage{
download_netmhc2pan_bin(
  netmhc2pan_bin_url = get_netmhc2pan_bin_url(),
  netmhc2pan_bin_tarfile_path = get_default_netmhc2pan_bin_tarfile_path(),
  verbose = FALSE,
  netmhc2pan_archive_filename = get_netmhc2pan_archive_filename(),
  temp_local_file = tempfile(pattern = "netmhc2pan_download_netmhc2pan_")
)
}
\arguments{
\item{netmhc2pan_bin_url}{URL to download the
NetMHCIIpan binary tarball file from,
similar to, for example,
\code{https://www.cbs.dtu.dk/download/12345678-1234-1234-1234-123456789ABC}.
Use \link{get_netmhc2pan_bin_url} to get the default URL.}

\item{netmhc2pan_bin_tarfile_path}{path of the
NetMHCIIpan binary tarball file}

\item{verbose}{set to TRUE for more output}

\item{netmhc2pan_archive_filename}{the NetMHC2pan archive
filename, for example \code{netMHCIIpan-3.2.Linux.tar.gz},
which is used in installation of NetMHC2pan.
Use \link{get_netmhc2pan_archive_filename} to get this filename.}

\item{temp_local_file}{path to the temporary file to store the URL to.
This file will be deleted afterwards.}
}
\value{
Nothing
}
\description{
Download the NetMHCIIpan binary tarball file
}
\author{
Richèl J.C. Bilderbeek
}
