% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc_graph.R
\name{assoc_graph}
\alias{assoc_graph}
\title{Association Graphs}
\usage{
assoc_graph(dat, cutoff = 0)
}
\arguments{
\item{dat}{dataframe with rows as observations and columns as variables. Variables must all be observed or transformed categorical with finite range spaces.}

\item{cutoff}{the cutoff point for the edges to be drawn based on joint entropies. Default is 0 and draws all edges.}
}
\value{
A ggraph object with nodes representing all variables in \code{dat} and edges
representing (the strength of) associations between them based on joint entropies.
}
\description{
Draws association graphs (graphical models) based on joint entropy values
to detect and visualize different dependence structures among the variables in the dataframe.
}
\details{
Draws association graphs based on given thresholds of joint entropy values
between pairs of variables represented as nodes. Thickness of edges between pairs of nodes/variables
indicates the strength of dependence between them. Isolated nodes are completely
independent and paths through certain nodes/variables indicate conditional dependencies.
}
\examples{
library(ggraph)
# use internal data set
data(lawdata)
df.att <- lawdata[[4]]

# three steps of data editing:
# 1. categorize variables 'years' and 'age' based on
# approximately three equally size groups (values based on cdf)
# 2. make sure all outcomes start from the value 0 (optional)
# 3. remove variable 'senior' as it consists of only unique values (thus redundant)
df.att.ed <- data.frame(
    status = df.att$status,
    gender = df.att$gender,
    office = df.att$office - 1,
    years = ifelse(df.att$years <= 3, 0,
        ifelse(df.att$years <= 13, 1, 2)
    ),
    age = ifelse(df.att$age <= 35, 0,
        ifelse(df.att$age <= 45, 1, 2)
    ),
    practice = df.att$practice,
    lawschool = df.att$lawschool - 1
)

# association graph based on cutoff 0.15
assoc_graph(df.att.ed, 0.15)
}
\references{
Frank, O., & Shafie, T. (2016). Multivariate entropy analysis of network data.
\emph{Bulletin of Sociological Methodology/Bulletin de Méthodologie Sociologique}, 129(1), 45-63.
}
\seealso{
\code{\link{joint_entropy}}
}
\author{
Termeh Shafie
}
