% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurospace.R
\name{coord_to_index}
\alias{coord_to_index}
\alias{coord_to_index,NeuroSpace,matrix-method}
\alias{coord_to_index,NeuroSpace,numeric-method}
\alias{coord_to_index,NeuroVol,matrix-method}
\title{convert n-dimensional real world coordinates to 1D indices}
\usage{
coord_to_index(x, coords)

\S4method{coord_to_index}{NeuroSpace,matrix}(x, coords)

\S4method{coord_to_index}{NeuroSpace,numeric}(x, coords)

\S4method{coord_to_index}{NeuroVol,matrix}(x, coords)
}
\arguments{
\item{x}{the object}

\item{coords}{a matrix of real world coordinates}
}
\value{
An integer \code{vector} of 1D indices corresponding to \code{coords}.
}
\description{
convert n-dimensional real world coordinates to 1D indices
}
\examples{
bvol <- NeuroVol(array(0, c(10,10,10)), NeuroSpace(c(10,10,10), c(1,1,1)))
coords <- matrix(c(.5,.5,.5, 1.5,1.5,1.5), ncol=3, byrow=TRUE)
idx <- coord_to_index(bvol, coords)
coords2 <- index_to_coord(bvol, idx)
all.equal(coords, coords2)
}
