% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnev.R
\name{rnev}
\alias{rnev}
\title{Draw nested extreme value random variables}
\usage{
rnev(
  N,
  sigma,
  nests,
  tol = 0.001,
  lower_int = NULL,
  upper_int = NULL,
  lower_eval = -10,
  upper_eval = NULL,
  resolution = 2^15
)
}
\arguments{
\item{N}{the number of vectors;}

\item{sigma}{the parameter that measures within-nest correlation, expressed either as a length-num_nests vector or as a scalar (in which case sigma is assumed constant across nests);}

\item{nests}{a vector of positive integers, indicating the nest of each alternative;}

\item{tol}{the tolerance on the requirement that the approximate pdf be real-valued, non-negative, and equal to zero at its boundary;}

\item{lower_int}{an argument passed to fourierin (default depends on sigma);}

\item{upper_int}{an argument passed to fourierin (default depends on sigma);}

\item{lower_eval}{an argument passed to fourierin (default = -10);}

\item{upper_eval}{an argument passed to fourierin (default depends on sigma);}

\item{resolution}{an argument passed to fourierin (default = 2^15).}
}
\value{
An N-by-length(nests) matrix, with each row being a draw from the nested extreme value distribution.
}
\description{
\code{rnev} draws nested extreme value random variables.
}
\examples{
rnev(10, 0.5, c(1,1,2,3))

}
