% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md.R
\name{md}
\alias{md}
\alias{dmd}
\alias{pmd}
\alias{qmd}
\alias{rmd}
\title{Maxwell Distribution}
\usage{
dmd(x, theta = 1, log = FALSE)

pmd(q, theta = 1, lower.tail = TRUE, log.p = FALSE)

qmd(p, theta = 1, lower.tail = TRUE)

rmd(n, theta = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{theta}{a scale parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dmd} gives the density, \code{pmd} gives the distribution
function, \code{qmd} gives the quantile function and \code{rmd} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
Maxwell distribution with parameter \code{scale}.
}
\details{
Maxwell distribution with \code{scale} parameter \eqn{\theta},
has density
\deqn{f\left( x\right) =\frac{4}{\sqrt{\pi }}
\frac{1}{\theta ^{3/2}}x^{2}e^{-x^{2}/\theta },}
where
\deqn{0\leq x<\infty ,~~\theta >0.}
}
\examples{
library(new.dist)
dmd(1,theta=2)
pmd(1,theta=2)
qmd(.4,theta=5)
rmd(10,theta=1)
}
\references{
Krishna, H., Vivekanand ve Kumar, K., 2015,
\emph{Estimation in Maxwell distribution with randomly censored data}, Journal of
statistical computation and simulation, 85 (17), 3560-3578.
}
