% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesTableSummary}
\alias{nhanesTableSummary}
\title{Summarize an NHANES table}
\usage{
nhanesTableSummary(nh_table, use = c("data", "codebook", "both"), ...)
}
\arguments{
\item{nh_table}{the name of a valid NHANES table}

\item{use}{character string, whether to create a summary from the
data itself or the codebook, which respectively use either the
NHANES SAS data files or the HTML documentation files. If
\code{use = "both"} then both are computed and merged; additional
arguments (\code{...}) are ignored in this case.}

\item{...}{additional arguments, usually passed on to either
\code{\link{nhanes}} or \code{\link{nhanesCodebook}} as
appropriate. Alternatively, the \code{src} argument can be used
to pass on an already available data frame or codebook, but this
must be consistent with the \code{use} argument.}
}
\value{
A data frame with one row per variable, with columns
  depending on the value of the \code{use} argument.
}
\description{
Computes a per-variable summary of a NHANES table either using the
actual data or its corresponding codebook
}
\details{
This function computes useful summaries of each variable included
in the specified NHANES table. The resulting data frame contains
one row for each variable in the table, and includes summary
measures that indicate the total number of observations, the
number of missing observations, whether the variable is most
likely numeric or categorical, whether the variable is related to
skipping other variables, etc. The precise details depend on the
\code{use} argument and are subject to change.
}
\examples{
\donttest{
## May fail if CDC website is unavailable
try(nhanesTableSummary('DEMO_D', use = "data"))
try(nhanesTableSummary('DEMO_D', use = "codebook"))
}
}
