# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Low-level C++ parser for association rules
#' @description
#' `parse_rules_cpp()` is the Rcpp-exposed engine behind \code{\link{parse_rules}}.
#' It accepts a data frame of association rules and returns a layout-agnostic
#' parsed structure consisting of an \emph{items} table and a \emph{rules} table.
#' This function is exported by Rcpp primarily for internal use and testing.
#'
#' @param rules_df A data frame with the \strong{required} columns:
#' \itemize{
#'   \item \code{Antecedent} (\code{character})
#'   \item \code{Consequence} (\code{character})
#'   \item \code{Support} (\code{numeric})
#'   \item \code{Confidence} (\code{numeric})
#'   \item \code{Fitness} (\code{numeric}; treated as \emph{lift} by convention)
#' }
#'
#' @details
#' \strong{Parsing rules}
#' \itemize{
#'   \item Both LHS and RHS are split on \code{","} or \code{"&"} \emph{outside} of
#'         brackets; leading/trailing whitespace is trimmed.
#'   \item A single outer brace pair \code{\{...\}} on RHS is stripped if present.
#'   \item Supported item syntaxes:
#'         \itemize{
#'           \item Categorical equality: \code{feature = value} (value may be quoted).
#'           \item Numeric interval: \code{feature in [lo, hi]}, \code{(lo, hi]}, etc.
#'           \item Relational: \code{feature >= x}, \code{> x}, \code{<= x}, \code{< x}.
#'         }
#'   \item For relational items, the unused bound is set to \code{NA}.
#'   \item \code{Fitness} is carried through as \code{lift}.
#' }
#'
#' @return A \code{list} with two data frames:
#' \describe{
#'   \item{\code{items}}{
#'     Columns:
#'     \itemize{
#'       \item \code{item_id}: integer, \strong{0-based} stable ID within this parsed object.
#'       \item \code{label}: original item string.
#'       \item \code{feature}: base feature name.
#'       \item \code{kind}: one of \code{"numeric"}, \code{"categorical"}, \code{"set"}, \code{"unknown"}.
#'       \item \code{category_value}: categorical value (quotes removed).
#'       \item \code{lo}, \code{hi}: numeric bounds (may be \code{NA}).
#'       \item \code{incl_low}, \code{incl_high}: logical inclusivity flags.
#'       \item \code{op}: one of \code{"<"}, \code{"<="}, \code{">"}, \code{">="}, \code{"="}, \code{"in"}.
#'       \item \code{label_long}, \code{label_short}: preformatted interval labels.
#'     }
#'   }
#'   \item{\code{rules}}{
#'     Columns:
#'     \itemize{
#'       \item \code{rule_id}: 1-based rule index (for display).
#'       \item \code{support}, \code{confidence}, \code{lift}: rule-level metrics.
#'       \item \code{lhs_item_ids}, \code{rhs_item_ids}: list-columns of integer vectors
#'             of 0-based \code{item_id}s.
#'       \item \code{antecedent_length}, \code{consequent_length}: integer lengths of LHS/RHS.
#'     }
#'   }
#' }
#'
#' @section Errors:
#' Throws an error if required columns are missing or have inconsistent lengths.
#'
#' @keywords internal
#' @export
parse_rules_cpp <- function(rules_df) {
    .Call(`_niarules_parse_rules_cpp`, rules_df)
}

#' @title Entry point for R to generate coral plot data from a set of association rules.
#'
#' @description This function takes a list of parsed association rules and produces two data frames:
#' one for the nodes and one for the edges of a coral plot. It acts as a wrapper that:
#' \itemize{
#'    \item Constructs the coral layout.
#'    \item Converts the resulting nodes and edges into R-compatible data frames.
#' }
#'
#' @param parsed A list as returned by `parse_rules()`, with components:
#' \itemize{
#'   \item \code{items}: \code{data.frame} with at least
#'     \code{item_id} (integer, 0-based) and \code{label} (character).
#'   \item \code{rules}: \code{data.frame} with at least
#'     \code{rule_id} (integer), \code{support}, \code{confidence}, \code{lift}
#'     (numeric), and list-columns \code{lhs_item_ids}, \code{rhs_item_ids}
#'     containing 0-based integer vectors.
#' }
#' @param grid_size Integer; number of grid cells per layout side used to place
#' corals on a near-square grid (e.g., 3 means a 3×3 canvas)
#' @param lhs_sort Character; metric used to sort antecedent items within each
#' LHS path when building the layout. One of \code{"confidence"},
#' \code{"support"}, \code{"lift"} (default \code{"confidence"}). Sorting is
#' applied in descending order of the chosen metric.
#'
#' @return A List containing two DataFrames:
#' \itemize{
#'    \item \code{edges}: DataFrame with start and end coordinates, line width, and color for each edge.
#'    \item \code{nodes}: DataFrame with position, radius, ID, and item label for each node.
#' }
#'
#' @keywords internal
#' @export
build_layout_cpp <- function(parsed, grid_size, lhs_sort = "confidence") {
    .Call(`_niarules_build_layout_cpp`, parsed, grid_size, lhs_sort)
}

